/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import com.google.common.collect.ImmutableMap;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;

public enum NodeAttributesMask implements UaEnumeration
{
    None(0),
    AccessLevel(1),
    ArrayDimensions(2),
    BrowseName(4),
    ContainsNoLoops(8),
    DataType(16),
    Description(32),
    DisplayName(64),
    EventNotifier(128),
    Executable(256),
    Historizing(512),
    InverseName(1024),
    IsAbstract(2048),
    MinimumSamplingInterval(4096),
    NodeClass(8192),
    NodeId(16384),
    Symmetric(32768),
    UserAccessLevel(65536),
    UserExecutable(131072),
    UserWriteMask(262144),
    ValueRank(524288),
    WriteMask(0x100000),
    Value(0x200000),
    All(0x3FFFFF),
    BaseNode(1335396),
    Object(1335524),
    ObjectTypeOrDataType(1337444),
    Variable(4026999),
    VariableType(3958902),
    Method(0x166164),
    ReferenceType(1371236),
    View(1335532);

    private final int value;
    private static final ImmutableMap<Integer, NodeAttributesMask> VALUES;

    private NodeAttributesMask(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static NodeAttributesMask from(Integer value) {
        if (value == null) {
            return null;
        }
        return (NodeAttributesMask)VALUES.getOrDefault((Object)value, null);
    }

    public static void encode(NodeAttributesMask nodeAttributesMask, UaEncoder encoder) {
        encoder.writeInt32(null, nodeAttributesMask.getValue());
    }

    public static NodeAttributesMask decode(UaDecoder decoder) {
        int value = decoder.readInt32(null);
        return (NodeAttributesMask)VALUES.getOrDefault((Object)value, null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (NodeAttributesMask e : NodeAttributesMask.values()) {
            builder.put((Object)e.getValue(), (Object)e);
        }
        VALUES = builder.build();
    }
}

