/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.util.StreamUtil;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.api.AddressSpaceManager;
import org.eclipse.milo.opcua.sdk.server.api.nodes.Node;
import org.eclipse.milo.opcua.sdk.server.api.nodes.ObjectTypeNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.events.FilterContext;
import org.eclipse.milo.opcua.sdk.server.events.OperatorContext;
import org.eclipse.milo.opcua.sdk.server.events.ValidationException;
import org.eclipse.milo.opcua.sdk.server.events.operators.Operator;
import org.eclipse.milo.opcua.sdk.server.events.operators.Operators;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.BaseEventNode;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.util.AttributeReader;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.FilterOperator;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.AttributeOperand;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilterElement;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilterElementResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilterResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ElementOperand;
import org.eclipse.milo.opcua.stack.core.types.structured.EventFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.EventFilterResult;
import org.eclipse.milo.opcua.stack.core.types.structured.FilterOperand;
import org.eclipse.milo.opcua.stack.core.types.structured.LiteralOperand;
import org.eclipse.milo.opcua.stack.core.types.structured.SimpleAttributeOperand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventContentFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventContentFilter.class);

    public static EventFilterResult validate(FilterContext context, EventFilter filter) throws UaException {
        SimpleAttributeOperand[] selectClauses = filter.getSelectClauses();
        if (selectClauses == null || selectClauses.length == 0) {
            throw new UaException(2152136704L);
        }
        SelectClauseValidationResult selectClauseResults = EventContentFilter.validateSelectClauses(context, selectClauses);
        ContentFilterResult whereClauseResult = EventContentFilter.validateWhereClause(context, filter.getWhereClause());
        return new EventFilterResult(selectClauseResults.statusCodes, selectClauseResults.diagnosticInfos, whereClauseResult);
    }

    private static SelectClauseValidationResult validateSelectClauses(FilterContext context, SimpleAttributeOperand[] selectClauses) {
        ArrayList<StatusCode> statusCodes = new ArrayList<StatusCode>();
        ArrayList<DiagnosticInfo> diagnosticInfos = new ArrayList<DiagnosticInfo>();
        for (SimpleAttributeOperand select : selectClauses) {
            try {
                EventContentFilter.validateSimpleOperand(context, select);
                statusCodes.add(StatusCode.GOOD);
                diagnosticInfos.add(DiagnosticInfo.NULL_VALUE);
            }
            catch (ValidationException e) {
                statusCodes.add(e.getStatusCode());
                diagnosticInfos.add(e.getDiagnosticInfo());
            }
            catch (Throwable t) {
                LOGGER.error("Unexpected error validating operand: {}", (Object)select, (Object)t);
                statusCodes.add(new StatusCode(0x80020000L));
                diagnosticInfos.add(DiagnosticInfo.NULL_VALUE);
            }
        }
        return new SelectClauseValidationResult(statusCodes.toArray(new StatusCode[0]), diagnosticInfos.toArray(new DiagnosticInfo[0]));
    }

    private static void validateSimpleOperand(FilterContext context, SimpleAttributeOperand select) throws ValidationException {
        NodeId eventTypeId = select.getTypeDefinitionId();
        if (eventTypeId != null && !eventTypeId.equals((Object)Identifiers.BaseEventType)) {
            UaNode node = context.getServer().getAddressSpaceManager().getManagedNode(eventTypeId).orElse(null);
            if (node == null || node.getNodeClass() != NodeClass.ObjectType) {
                throw new ValidationException(2153971712L);
            }
            QualifiedName[] browsePath = select.getBrowsePath();
            if (browsePath == null || Arrays.stream(browsePath).anyMatch(Objects::isNull)) {
                throw new ValidationException(0x80600000L);
            }
            Node relativeNode = EventContentFilter.getRelativeNode(context, node, browsePath);
            if (relativeNode == null) {
                throw new ValidationException(2150891520L);
            }
            UInteger attributeId = select.getAttributeId();
            ImmutableSet validAttributes = AttributeId.getAttributes((NodeClass)relativeNode.getNodeClass());
            boolean validAttribute = AttributeId.from((UInteger)attributeId).map(arg_0 -> ((ImmutableSet)validAttributes).contains(arg_0)).orElse(false);
            if (!validAttribute) {
                throw new ValidationException(2150957056L);
            }
            String indexRange = select.getIndexRange();
            if (indexRange != null) {
                if (relativeNode instanceof VariableNode) {
                    int valueRank = ((VariableNode)relativeNode).getValueRank();
                    if (valueRank == -1) {
                        throw new ValidationException(2151022592L);
                    }
                } else {
                    throw new ValidationException(2151022592L);
                }
            }
        }
    }

    @Nullable
    private static Node getRelativeNode(FilterContext context, @Nonnull UaNode startingNode, @Nonnull QualifiedName[] browsePath) {
        QualifiedName targetBrowsePath;
        UaNode relativeNode = startingNode;
        Predicate<UaNode> nodePredicate = n -> n.getNodeClass() == NodeClass.Object || n.getNodeClass() == NodeClass.Variable;
        Predicate<Reference> referencePredicate = r -> r.isForward() && r.subtypeOf(Identifiers.HierarchicalReferences, context.getServer().getReferenceTypes());
        QualifiedName[] qualifiedNameArray = browsePath;
        int n2 = qualifiedNameArray.length;
        for (int i = 0; i < n2 && (relativeNode = (UaNode)relativeNode.findNode(targetBrowsePath = qualifiedNameArray[i], nodePredicate, referencePredicate).orElse(null)) != null; ++i) {
        }
        return relativeNode;
    }

    private static ContentFilterResult validateWhereClause(FilterContext context, ContentFilter whereClause) {
        ContentFilterElement[] filterElements = whereClause.getElements();
        if (filterElements == null) {
            return new ContentFilterResult(new ContentFilterElementResult[0], new DiagnosticInfo[0]);
        }
        ContentFilterElementResult[] elementResults = (ContentFilterElementResult[])Arrays.stream(filterElements).map(e -> EventContentFilter.validateFilterElement(context, e)).toArray(ContentFilterElementResult[]::new);
        return new ContentFilterResult(elementResults, new DiagnosticInfo[0]);
    }

    private static ContentFilterElementResult validateFilterElement(@Nonnull FilterContext context, @Nonnull ContentFilterElement filterElement) {
        FilterOperator filterOperator = filterElement.getFilterOperator();
        if (!Operators.SUPPORTED_OPERATORS.contains((Object)filterOperator)) {
            return new ContentFilterElementResult(new StatusCode(2160197632L), new StatusCode[0], new DiagnosticInfo[0]);
        }
        ExtensionObject[] xos = filterElement.getFilterOperands();
        if (xos == null || xos.length == 0) {
            return new ContentFilterElementResult(new StatusCode(2160263168L), new StatusCode[0], new DiagnosticInfo[0]);
        }
        FilterOperand[] operands = new FilterOperand[xos.length];
        StatusCode[] operandStatusCodes = new StatusCode[xos.length];
        for (int i = 0; i < xos.length; ++i) {
            Object operand = xos[i].decodeOrNull(context.getServer().getSerializationContext());
            if (operand instanceof FilterOperand) {
                operands[i] = (FilterOperand)operand;
                if (operand instanceof SimpleAttributeOperand) {
                    try {
                        EventContentFilter.validateSimpleOperand(context, (SimpleAttributeOperand)operand);
                        operandStatusCodes[i] = StatusCode.GOOD;
                    }
                    catch (ValidationException e) {
                        operandStatusCodes[i] = e.getStatusCode();
                    }
                    continue;
                }
                if (operand instanceof ElementOperand) {
                    operandStatusCodes[i] = StatusCode.GOOD;
                    continue;
                }
                if (operand instanceof LiteralOperand) {
                    operandStatusCodes[i] = StatusCode.GOOD;
                    continue;
                }
                operandStatusCodes[i] = new StatusCode(2152267776L);
                continue;
            }
            operandStatusCodes[i] = new StatusCode(2152267776L);
        }
        StatusCode operatorStatus = StatusCode.GOOD;
        try {
            Operator<?> operator = EventContentFilter.getOperator(filterOperator);
            operator.validate(context, operands);
        }
        catch (ValidationException e) {
            operatorStatus = e.getStatusCode();
        }
        return new ContentFilterElementResult(operatorStatus, operandStatusCodes, new DiagnosticInfo[0]);
    }

    public static Variant[] select(@Nonnull FilterContext context, @Nonnull SimpleAttributeOperand[] selectClauses, @Nonnull BaseEventNode eventNode) {
        return (Variant[])Arrays.stream(selectClauses).map(operand -> {
            try {
                return new Variant(EventContentFilter.getSimpleAttribute(context, operand, eventNode));
            }
            catch (UaException e) {
                return Variant.NULL_VALUE;
            }
        }).toArray(Variant[]::new);
    }

    public static boolean evaluate(@Nonnull FilterContext context, @Nonnull ContentFilter whereClause, @Nonnull BaseEventNode eventNode) throws UaException {
        if (whereClause.getElements() == null || whereClause.getElements().length == 0) {
            return true;
        }
        ContentFilterElement[] elements = whereClause.getElements();
        DefaultOperatorContext operatorContext = new DefaultOperatorContext(context, elements);
        Object result = EventContentFilter.evaluate(operatorContext, eventNode, elements[0]);
        if (result == null) {
            return false;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        throw new UaException(0x80480000L);
    }

    @Nullable
    private static Object evaluate(@Nonnull OperatorContext context, @Nonnull BaseEventNode eventNode, @Nonnull ContentFilterElement element) throws UaException {
        FilterOperator filterOperator = element.getFilterOperator();
        if (filterOperator == null) {
            throw new UaException(2160132096L);
        }
        FilterOperand[] filterOperands = EventContentFilter.decodeOperands(context.getServer().getSerializationContext(), element.getFilterOperands());
        Operator<?> operator = EventContentFilter.getOperator(filterOperator);
        return operator.apply(context, eventNode, filterOperands);
    }

    @Nonnull
    private static FilterOperand[] decodeOperands(SerializationContext context, @Nullable ExtensionObject[] operandXos) {
        if (operandXos == null) {
            return new FilterOperand[0];
        }
        return (FilterOperand[])Arrays.stream(operandXos).map(xo -> (FilterOperand)xo.decode(context)).toArray(FilterOperand[]::new);
    }

    @Nonnull
    private static Operator<?> getOperator(@Nonnull FilterOperator filterOperator) {
        switch (filterOperator) {
            case Equals: {
                return Operators.EQUALS;
            }
            case IsNull: {
                return Operators.IS_NULL;
            }
            case GreaterThan: {
                return Operators.GREATER_THAN;
            }
            case LessThan: {
                return Operators.LESS_THAN;
            }
            case GreaterThanOrEqual: {
                return Operators.GREATER_THAN_OR_EQUAL;
            }
            case LessThanOrEqual: {
                return Operators.LESS_THAN_OR_EQUAL;
            }
            case Like: {
                return Operators.UNSUPPORTED;
            }
            case Not: {
                return Operators.NOT;
            }
            case Between: {
                return Operators.UNSUPPORTED;
            }
            case InList: {
                return Operators.UNSUPPORTED;
            }
            case And: {
                return Operators.UNSUPPORTED;
            }
            case Or: {
                return Operators.UNSUPPORTED;
            }
            case Cast: {
                return Operators.CAST;
            }
            case BitwiseAnd: {
                return Operators.UNSUPPORTED;
            }
            case BitwiseOr: {
                return Operators.UNSUPPORTED;
            }
            case InView: {
                return Operators.UNSUPPORTED;
            }
            case OfType: {
                return Operators.UNSUPPORTED;
            }
            case RelatedTo: {
                return Operators.UNSUPPORTED;
            }
        }
        return Operators.UNSUPPORTED;
    }

    private static Object getAttribute(@Nonnull FilterContext context, @Nonnull AttributeOperand operand, @Nonnull BaseEventNode eventNode) throws UaException {
        throw new UaException(2152136704L);
    }

    private static Object getSimpleAttribute(@Nonnull FilterContext context, @Nonnull SimpleAttributeOperand operand, @Nonnull BaseEventNode eventNode) throws UaException {
        NodeId typeDefinitionId = operand.getTypeDefinitionId();
        if (typeDefinitionId != null && !typeDefinitionId.equals((Object)Identifiers.BaseEventType)) {
            boolean sameOrSubtype;
            NodeId eventTypeDefinitionId = eventNode.getTypeDefinitionNode().getNodeId();
            boolean bl = sameOrSubtype = typeDefinitionId.equals((Object)eventTypeDefinitionId) || EventContentFilter.subtypeOf(eventTypeDefinitionId, typeDefinitionId, context.getServer());
            if (!sameOrSubtype) {
                return null;
            }
        }
        QualifiedName[] browsePath = operand.getBrowsePath();
        UaNode targetNode = eventNode;
        if (browsePath != null) {
            QualifiedName targetBrowsePath;
            Predicate<UaNode> nodePredicate = n -> n.getNodeClass() == NodeClass.Object || n.getNodeClass() == NodeClass.Variable;
            Predicate<Reference> referencePredicate = r -> r.isForward() && r.subtypeOf(Identifiers.HierarchicalReferences, context.getServer().getReferenceTypes());
            QualifiedName[] qualifiedNameArray = browsePath;
            int n2 = qualifiedNameArray.length;
            for (int i = 0; i < n2 && (targetNode = (UaNode)targetNode.findNode(targetBrowsePath = qualifiedNameArray[i], nodePredicate, referencePredicate).orElse(null)) != null; ++i) {
            }
        }
        if (targetNode != null) {
            AttributeId attributeId = (AttributeId)AttributeId.from((UInteger)operand.getAttributeId()).orElseThrow(() -> new UaException(2150957056L));
            String indexRange = operand.getIndexRange();
            AttributeContext attributeContext = new AttributeContext(context.getServer(), context.getSession().orElse(null));
            DataValue value = AttributeReader.readAttribute(attributeContext, targetNode, attributeId, TimestampsToReturn.Neither, indexRange, QualifiedName.NULL_VALUE);
            return value.getValue().getValue();
        }
        return null;
    }

    private static boolean subtypeOf(NodeId typeId, NodeId superTypeId, OpcUaServer server) {
        UaNode node = server.getAddressSpaceManager().getManagedNode(typeId).orElse(null);
        if (node instanceof ObjectTypeNode) {
            return EventContentFilter.getParentTypeDefinition(node, server).map(Node::getNodeId).map(id -> id.equals((Object)superTypeId) || EventContentFilter.subtypeOf(id, superTypeId, server)).orElse(false);
        }
        return false;
    }

    private static Optional<UaNode> getParentTypeDefinition(UaNode node, OpcUaServer server) {
        AddressSpaceManager addressSpaceManager = server.getAddressSpaceManager();
        NamespaceTable namespaceTable = server.getNamespaceTable();
        return addressSpaceManager.getManagedReferences(node.getNodeId()).stream().filter(Reference.SUBTYPE_OF).flatMap(r -> StreamUtil.opt2stream((Optional)r.getTargetNodeId().local(namespaceTable))).findFirst().flatMap(addressSpaceManager::getManagedNode);
    }

    static class SelectClauseValidationResult {
        private final StatusCode[] statusCodes;
        private final DiagnosticInfo[] diagnosticInfos;

        public SelectClauseValidationResult(StatusCode[] statusCodes, DiagnosticInfo[] diagnosticInfos) {
            this.statusCodes = statusCodes;
            this.diagnosticInfos = diagnosticInfos;
        }
    }

    static class DefaultOperatorContext
    implements OperatorContext {
        private final FilterContext filterContext;
        private final ContentFilterElement[] elements;

        DefaultOperatorContext(FilterContext filterContext, ContentFilterElement[] elements) {
            this.filterContext = filterContext;
            this.elements = elements;
        }

        @Override
        public Optional<Session> getSession() {
            return this.filterContext.getSession();
        }

        @Override
        public OpcUaServer getServer() {
            return this.filterContext.getServer();
        }

        @Override
        public ContentFilterElement[] getElements() {
            return this.elements;
        }

        @Override
        @Nullable
        public Object resolve(FilterOperand operand, BaseEventNode eventNode) throws UaException {
            if (operand instanceof LiteralOperand) {
                return ((LiteralOperand)operand).getValue().getValue();
            }
            if (operand instanceof ElementOperand) {
                UInteger index = ((ElementOperand)operand).getIndex();
                ContentFilterElement element = this.elements[index.intValue()];
                return EventContentFilter.evaluate(this, eventNode, element);
            }
            if (operand instanceof AttributeOperand) {
                AttributeOperand ao = (AttributeOperand)operand;
                return EventContentFilter.getAttribute(this.filterContext, ao, eventNode);
            }
            if (operand instanceof SimpleAttributeOperand) {
                SimpleAttributeOperand sao = (SimpleAttributeOperand)operand;
                return EventContentFilter.getSimpleAttribute(this.filterContext, sao, eventNode);
            }
            throw new UaException(2152267776L);
        }
    }
}

