/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.XmlElement;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;

public class TypeUtil {
    private static final ImmutableMap<Integer, Class<?>> BUILTIN_TYPES;
    private static final ImmutableMap<Class<?>, Integer> BUILTIN_TYPES_INVERSE;
    private static final ImmutableMap<Class<?>, Integer> PRIMITIVE_BUILTIN_TYPES;
    private static final ImmutableMap<Integer, Class<?>> PRIMITIVE_BUILTIN_TYPES_INVERSE;

    public static int getBuiltinTypeId(Class<?> backingType) {
        if (backingType.isPrimitive()) {
            return (Integer)PRIMITIVE_BUILTIN_TYPES.getOrDefault(backingType, (Object)-1);
        }
        return (Integer)BUILTIN_TYPES_INVERSE.getOrDefault(backingType, (Object)-1);
    }

    public static boolean isBuiltin(NodeId typeId) {
        return BUILTIN_TYPES.containsKey((Object)TypeUtil.id(typeId));
    }

    public static boolean isBuiltin(ExpandedNodeId typeId) {
        return BUILTIN_TYPES.containsKey((Object)TypeUtil.id(typeId));
    }

    @Nullable
    public static Class<?> getBackingClass(int id) {
        return (Class)BUILTIN_TYPES.get((Object)id);
    }

    @Nullable
    public static Class<?> getBackingClass(NodeId typeId) {
        return TypeUtil.getBackingClass(TypeUtil.id(typeId));
    }

    @Nullable
    public static Class<?> getPrimitiveBackingClass(int id) {
        return (Class)PRIMITIVE_BUILTIN_TYPES_INVERSE.getOrDefault((Object)id, TypeUtil.getBackingClass(id));
    }

    @Nullable
    public static Class<?> getPrimitiveBackingClass(NodeId typeId) {
        return TypeUtil.getPrimitiveBackingClass(TypeUtil.id(typeId));
    }

    private static int id(NodeId nodeId) {
        if (nodeId.getIdentifier() instanceof UInteger) {
            return ((UInteger)nodeId.getIdentifier()).intValue();
        }
        return -1;
    }

    private static int id(ExpandedNodeId nodeId) {
        if (nodeId.getIdentifier() instanceof UInteger) {
            return ((UInteger)nodeId.getIdentifier()).intValue();
        }
        return -1;
    }

    static {
        HashBiMap builtinTypes = HashBiMap.create();
        builtinTypes.put((Object)1, Boolean.class);
        builtinTypes.put((Object)2, Byte.class);
        builtinTypes.put((Object)3, UByte.class);
        builtinTypes.put((Object)4, Short.class);
        builtinTypes.put((Object)5, UShort.class);
        builtinTypes.put((Object)6, Integer.class);
        builtinTypes.put((Object)7, UInteger.class);
        builtinTypes.put((Object)8, Long.class);
        builtinTypes.put((Object)9, ULong.class);
        builtinTypes.put((Object)10, Float.class);
        builtinTypes.put((Object)11, Double.class);
        builtinTypes.put((Object)12, String.class);
        builtinTypes.put((Object)13, DateTime.class);
        builtinTypes.put((Object)14, UUID.class);
        builtinTypes.put((Object)15, ByteString.class);
        builtinTypes.put((Object)16, XmlElement.class);
        builtinTypes.put((Object)17, NodeId.class);
        builtinTypes.put((Object)18, ExpandedNodeId.class);
        builtinTypes.put((Object)19, StatusCode.class);
        builtinTypes.put((Object)20, QualifiedName.class);
        builtinTypes.put((Object)21, LocalizedText.class);
        builtinTypes.put((Object)22, ExtensionObject.class);
        builtinTypes.put((Object)23, DataValue.class);
        builtinTypes.put((Object)24, Variant.class);
        builtinTypes.put((Object)25, DiagnosticInfo.class);
        BUILTIN_TYPES = ImmutableMap.copyOf((Map)builtinTypes);
        BUILTIN_TYPES_INVERSE = ImmutableMap.copyOf((Map)builtinTypes.inverse());
        HashBiMap primitiveBuiltinTypes = HashBiMap.create();
        primitiveBuiltinTypes.put(Boolean.TYPE, (Object)1);
        primitiveBuiltinTypes.put(Byte.TYPE, (Object)2);
        primitiveBuiltinTypes.put(Short.TYPE, (Object)4);
        primitiveBuiltinTypes.put(Integer.TYPE, (Object)6);
        primitiveBuiltinTypes.put(Long.TYPE, (Object)8);
        primitiveBuiltinTypes.put(Float.TYPE, (Object)10);
        primitiveBuiltinTypes.put(Double.TYPE, (Object)11);
        PRIMITIVE_BUILTIN_TYPES = ImmutableMap.copyOf((Map)primitiveBuiltinTypes);
        PRIMITIVE_BUILTIN_TYPES_INVERSE = ImmutableMap.copyOf((Map)primitiveBuiltinTypes.inverse());
    }
}

