/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;

public class ReadResponse
implements UaResponseMessage {
    public static final NodeId TypeId = Identifiers.ReadResponse;
    public static final NodeId BinaryEncodingId = Identifiers.ReadResponse_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ReadResponse_Encoding_DefaultXml;
    protected final ResponseHeader responseHeader;
    protected final DataValue[] results;
    protected final DiagnosticInfo[] diagnosticInfos;

    public ReadResponse() {
        this.responseHeader = null;
        this.results = null;
        this.diagnosticInfos = null;
    }

    public ReadResponse(ResponseHeader responseHeader, DataValue[] results, DiagnosticInfo[] diagnosticInfos) {
        this.responseHeader = responseHeader;
        this.results = results;
        this.diagnosticInfos = diagnosticInfos;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    @Nullable
    public DataValue[] getResults() {
        return this.results;
    }

    @Nullable
    public DiagnosticInfo[] getDiagnosticInfos() {
        return this.diagnosticInfos;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ResponseHeader", (Object)this.responseHeader).add("Results", (Object)this.results).add("DiagnosticInfos", (Object)this.diagnosticInfos).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<ReadResponse> {
        @Override
        public Class<ReadResponse> getType() {
            return ReadResponse.class;
        }

        @Override
        public ReadResponse decode(UaDecoder decoder) throws UaSerializationException {
            ResponseHeader responseHeader = decoder.readBuiltinStruct("ResponseHeader", ResponseHeader.class);
            DataValue[] results = decoder.readArray("Results", decoder::readDataValue, DataValue.class);
            DiagnosticInfo[] diagnosticInfos = decoder.readArray("DiagnosticInfos", decoder::readDiagnosticInfo, DiagnosticInfo.class);
            return new ReadResponse(responseHeader, results, diagnosticInfos);
        }

        @Override
        public void encode(ReadResponse value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("ResponseHeader", value.responseHeader, ResponseHeader.class);
            encoder.writeArray("Results", value.results, encoder::writeDataValue);
            encoder.writeArray("DiagnosticInfos", value.diagnosticInfos, encoder::writeDiagnosticInfo);
        }
    }
}

