/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import com.google.common.collect.ImmutableMap;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;

public enum RedundancySupport implements UaEnumeration
{
    None(0),
    Cold(1),
    Warm(2),
    Hot(3),
    Transparent(4),
    HotAndMirrored(5);

    private final int value;
    private static final ImmutableMap<Integer, RedundancySupport> VALUES;

    private RedundancySupport(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static RedundancySupport from(Integer value) {
        if (value == null) {
            return null;
        }
        return (RedundancySupport)VALUES.getOrDefault((Object)value, null);
    }

    public static void encode(RedundancySupport redundancySupport, UaEncoder encoder) {
        encoder.writeInt32(null, redundancySupport.getValue());
    }

    public static RedundancySupport decode(UaDecoder decoder) {
        int value = decoder.readInt32(null);
        return (RedundancySupport)VALUES.getOrDefault((Object)value, null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (RedundancySupport e : RedundancySupport.values()) {
            builder.put((Object)e.getValue(), (Object)e);
        }
        VALUES = builder.build();
    }
}

