/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.channel;

import com.google.common.primitives.Bytes;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.channel.ChannelSecurity;
import org.eclipse.milo.opcua.stack.core.security.SecurityAlgorithm;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.util.DigestUtil;

public interface SecureChannel {
    public KeyPair getKeyPair();

    public X509Certificate getLocalCertificate();

    public List<X509Certificate> getLocalCertificateChain();

    public X509Certificate getRemoteCertificate();

    public List<X509Certificate> getRemoteCertificateChain();

    public SecurityPolicy getSecurityPolicy();

    public MessageSecurityMode getMessageSecurityMode();

    public long getChannelId();

    public ChannelSecurity getChannelSecurity();

    public ChannelSecurity.SecretKeys getEncryptionKeys(ChannelSecurity.SecurityKeys var1);

    public ChannelSecurity.SecretKeys getDecryptionKeys(ChannelSecurity.SecurityKeys var1);

    public ByteString getLocalNonce();

    public ByteString getRemoteNonce();

    default public ByteString getLocalCertificateBytes() throws UaException {
        try {
            return this.getLocalCertificate() != null ? ByteString.of(this.getLocalCertificate().getEncoded()) : ByteString.NULL_VALUE;
        }
        catch (CertificateEncodingException e) {
            throw new UaException(2148663296L, (Throwable)e);
        }
    }

    default public ByteString getLocalCertificateChainBytes() throws UaException {
        List<X509Certificate> localCertificateChain = this.getLocalCertificateChain();
        if (localCertificateChain != null) {
            return SecureChannel.getCertificateChainBytes(localCertificateChain);
        }
        return ByteString.NULL_VALUE;
    }

    default public ByteString getLocalCertificateThumbprint() throws UaException {
        try {
            return this.getLocalCertificate() != null ? ByteString.of(DigestUtil.sha1(this.getLocalCertificate().getEncoded())) : ByteString.NULL_VALUE;
        }
        catch (CertificateEncodingException e) {
            throw new UaException(2148663296L, (Throwable)e);
        }
    }

    default public ByteString getRemoteCertificateBytes() throws UaException {
        try {
            return this.getRemoteCertificate() != null ? ByteString.of(this.getRemoteCertificate().getEncoded()) : ByteString.NULL_VALUE;
        }
        catch (CertificateEncodingException e) {
            throw new UaException(2148663296L, (Throwable)e);
        }
    }

    default public ByteString getRemoteCertificateChainBytes() throws UaException {
        List<X509Certificate> remoteCertificateChain = this.getRemoteCertificateChain();
        if (remoteCertificateChain != null) {
            return SecureChannel.getCertificateChainBytes(remoteCertificateChain);
        }
        return ByteString.NULL_VALUE;
    }

    default public ByteString getRemoteCertificateThumbprint() throws UaException {
        try {
            return this.getRemoteCertificate() != null ? ByteString.of(DigestUtil.sha1(this.getRemoteCertificate().getEncoded())) : ByteString.NULL_VALUE;
        }
        catch (CertificateEncodingException e) {
            throw new UaException(2148663296L, (Throwable)e);
        }
    }

    default public int getLocalAsymmetricCipherTextBlockSize() {
        if (this.isAsymmetricEncryptionEnabled()) {
            SecurityAlgorithm algorithm = this.getSecurityPolicy().getAsymmetricEncryptionAlgorithm();
            return SecureChannel.getAsymmetricCipherTextBlockSize(this.getLocalCertificate(), algorithm);
        }
        return 1;
    }

    default public int getRemoteAsymmetricCipherTextBlockSize() {
        if (this.isAsymmetricEncryptionEnabled()) {
            SecurityAlgorithm algorithm = this.getSecurityPolicy().getAsymmetricEncryptionAlgorithm();
            return SecureChannel.getAsymmetricCipherTextBlockSize(this.getRemoteCertificate(), algorithm);
        }
        return 1;
    }

    default public int getLocalAsymmetricPlainTextBlockSize() {
        if (this.isAsymmetricEncryptionEnabled()) {
            SecurityAlgorithm algorithm = this.getSecurityPolicy().getAsymmetricEncryptionAlgorithm();
            return SecureChannel.getAsymmetricPlainTextBlockSize(this.getLocalCertificate(), algorithm);
        }
        return 1;
    }

    default public int getRemoteAsymmetricPlainTextBlockSize() {
        if (this.isAsymmetricEncryptionEnabled()) {
            SecurityAlgorithm algorithm = this.getSecurityPolicy().getAsymmetricEncryptionAlgorithm();
            return SecureChannel.getAsymmetricPlainTextBlockSize(this.getRemoteCertificate(), algorithm);
        }
        return 1;
    }

    default public int getLocalAsymmetricSignatureSize() {
        SecurityAlgorithm algorithm = this.getSecurityPolicy().getAsymmetricSignatureAlgorithm();
        return SecureChannel.getAsymmetricSignatureSize(this.getLocalCertificate(), algorithm);
    }

    default public int getRemoteAsymmetricSignatureSize() {
        SecurityAlgorithm algorithm = this.getSecurityPolicy().getAsymmetricSignatureAlgorithm();
        return SecureChannel.getAsymmetricSignatureSize(this.getRemoteCertificate(), algorithm);
    }

    default public boolean isAsymmetricSigningEnabled() {
        return this.getSecurityPolicy() != SecurityPolicy.None && this.getLocalCertificate() != null;
    }

    default public boolean isAsymmetricEncryptionEnabled() {
        return this.getSecurityPolicy() != SecurityPolicy.None && this.getLocalCertificate() != null && this.getRemoteCertificate() != null;
    }

    default public int getSymmetricBlockSize() {
        if (this.isSymmetricEncryptionEnabled()) {
            SecurityAlgorithm algorithm = this.getSecurityPolicy().getSymmetricEncryptionAlgorithm();
            switch (algorithm) {
                case Aes128: 
                case Aes256: {
                    return 16;
                }
            }
            return 1;
        }
        return 1;
    }

    default public int getSymmetricSignatureSize() {
        SecurityAlgorithm algorithm = this.getSecurityPolicy().getSymmetricSignatureAlgorithm();
        switch (algorithm) {
            case HmacSha1: {
                return 20;
            }
            case HmacSha256: {
                return 32;
            }
        }
        return 0;
    }

    default public int getSymmetricSignatureKeySize() {
        switch (this.getSecurityPolicy()) {
            case None: {
                return 0;
            }
            case Basic128Rsa15: {
                return 16;
            }
            case Basic256: {
                return 24;
            }
            case Basic256Sha256: 
            case Aes128_Sha256_RsaOaep: 
            case Aes256_Sha256_RsaPss: {
                return 32;
            }
        }
        return 0;
    }

    default public int getSymmetricEncryptionKeySize() {
        switch (this.getSecurityPolicy()) {
            case None: {
                return 0;
            }
            case Basic128Rsa15: 
            case Aes128_Sha256_RsaOaep: {
                return 16;
            }
            case Basic256: 
            case Basic256Sha256: 
            case Aes256_Sha256_RsaPss: {
                return 32;
            }
        }
        return 0;
    }

    default public boolean isSymmetricSigningEnabled() {
        return this.getLocalCertificate() != null && this.getSecurityPolicy() != SecurityPolicy.None && (this.getMessageSecurityMode() == MessageSecurityMode.Sign || this.getMessageSecurityMode() == MessageSecurityMode.SignAndEncrypt);
    }

    default public boolean isSymmetricEncryptionEnabled() {
        return this.getRemoteCertificate() != null && this.getSecurityPolicy() != SecurityPolicy.None && this.getMessageSecurityMode() == MessageSecurityMode.SignAndEncrypt;
    }

    public static int getAsymmetricKeyLength(Certificate certificate) {
        PublicKey publicKey = certificate != null ? certificate.getPublicKey() : null;
        return publicKey instanceof RSAPublicKey ? ((RSAPublicKey)publicKey).getModulus().bitLength() : 0;
    }

    public static int getAsymmetricSignatureSize(Certificate certificate, SecurityAlgorithm algorithm) {
        switch (algorithm) {
            case RsaSha1: 
            case RsaSha256: 
            case RsaSha256Pss: {
                return (SecureChannel.getAsymmetricKeyLength(certificate) + 7) / 8;
            }
        }
        return 0;
    }

    public static int getAsymmetricCipherTextBlockSize(Certificate certificate, SecurityAlgorithm algorithm) {
        switch (algorithm) {
            case Rsa15: 
            case RsaOaepSha1: 
            case RsaOaepSha256: {
                return (SecureChannel.getAsymmetricKeyLength(certificate) + 7) / 8;
            }
        }
        return 1;
    }

    public static int getAsymmetricPlainTextBlockSize(X509Certificate certificate, SecurityAlgorithm algorithm) {
        switch (algorithm) {
            case Rsa15: {
                return (SecureChannel.getAsymmetricKeyLength(certificate) + 7) / 8 - 11;
            }
            case RsaOaepSha1: {
                return (SecureChannel.getAsymmetricKeyLength(certificate) + 7) / 8 - 42;
            }
            case RsaOaepSha256: {
                return (SecureChannel.getAsymmetricKeyLength(certificate) + 7) / 8 - 66;
            }
        }
        return 1;
    }

    public static ByteString getCertificateChainBytes(List<X509Certificate> certificateChain) throws UaException {
        ArrayList<byte[]> certificates = new ArrayList<byte[]>(certificateChain.size());
        for (X509Certificate certificate : certificateChain) {
            try {
                certificates.add(certificate.getEncoded());
            }
            catch (CertificateEncodingException e) {
                throw new UaException(2148663296L, (Throwable)e);
            }
        }
        byte[] encoded = certificates.stream().reduce(new byte[0], (xva$0, xva$1) -> Bytes.concat((byte[][])new byte[][]{xva$0, xva$1}));
        return ByteString.of(encoded);
    }
}

