/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.microprofile.metrics;

import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.microprofile.metrics.AbstractMicroProfileMetricsProducer;
import org.apache.camel.component.microprofile.metrics.MicroProfileMetricsEndpoint;
import org.apache.camel.component.microprofile.metrics.TimerAction;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroProfileMetricsTimerProducer
extends AbstractMicroProfileMetricsProducer<Timer> {
    private static final Logger LOG = LoggerFactory.getLogger(MicroProfileMetricsTimerProducer.class);

    public MicroProfileMetricsTimerProducer(MicroProfileMetricsEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    @Override
    protected void doProcess(Exchange exchange, MicroProfileMetricsEndpoint endpoint, Timer timer) {
        String propertyName = this.getPropertyName(endpoint.getMetricName());
        Timer.Context context = this.getTimerContextFromExchange(exchange, propertyName);
        if (context != null) {
            context.stop();
        } else {
            LOG.warn("Timer context for metric '{}' was not found", (Object)propertyName);
        }
        exchange.removeProperty(propertyName);
    }

    @Override
    protected void doProcess(Exchange exchange, Metadata metadata, List<Tag> tags) {
        String actionString = this.getEndpoint().getAction().toUpperCase(Locale.US);
        TimerAction action = (TimerAction)((Object)exchange.getIn().getHeader("CamelMicroProfileMetricsTimerAction", (Object)actionString, TimerAction.class));
        if (action == TimerAction.START) {
            this.handleStart(exchange, metadata, tags);
        } else {
            this.handleStop(exchange, metadata, tags);
        }
    }

    @Override
    protected Function<MetricRegistry, Timer> registerMetric(Metadata metadata, List<Tag> tags) {
        return metricRegistry -> metricRegistry.timer(metadata, tags.toArray(new Tag[0]));
    }

    private void handleStart(Exchange exchange, Metadata metadata, List<Tag> tags) {
        String propertyName = this.getPropertyName(metadata.getName());
        Timer.Context context = this.getTimerContextFromExchange(exchange, propertyName);
        if (context == null) {
            Timer timer = (Timer)this.getOrRegisterMetric(metadata, tags);
            exchange.setProperty(propertyName, (Object)timer.time());
        } else {
            LOG.warn("Timer '{}' is already running", (Object)metadata.getName());
        }
    }

    private void handleStop(Exchange exchange, Metadata metadata, List<Tag> tags) {
        if (this.getTimerContextFromExchange(exchange, this.getPropertyName(metadata.getName())) != null) {
            this.doProcess(exchange, this.getEndpoint(), (Timer)this.getOrRegisterMetric(metadata, tags));
        }
    }

    private String getPropertyName(String metricName) {
        return "timer:" + metricName;
    }

    private Timer.Context getTimerContextFromExchange(Exchange exchange, String propertyName) {
        return (Timer.Context)exchange.getProperty(propertyName, Timer.Context.class);
    }
}

