/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.microprofile.metrics;

import java.util.List;
import java.util.function.Function;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.microprofile.metrics.AbstractMicroProfileMetricsProducer;
import org.apache.camel.component.microprofile.metrics.MicroProfileMetricsEndpoint;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;

public class MicroProfileMetricsConcurrentGaugeProducer
extends AbstractMicroProfileMetricsProducer<ConcurrentGauge> {
    public MicroProfileMetricsConcurrentGaugeProducer(MicroProfileMetricsEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    @Override
    protected void doProcess(Exchange exchange, MicroProfileMetricsEndpoint endpoint, ConcurrentGauge gauge) {
        Message in = exchange.getIn();
        Boolean finalIncrement = this.getBooleanHeader(in, "CamelMicroProfileMetricsGaugeIncrement", endpoint.getGaugeIncrement());
        Boolean finalDecrement = this.getBooleanHeader(in, "CamelMicroProfileMetricsGaugeDecrement", endpoint.getGaugeDecrement());
        if (finalIncrement.booleanValue() && !finalDecrement.booleanValue()) {
            gauge.inc();
        } else if (finalDecrement.booleanValue()) {
            gauge.dec();
        }
    }

    @Override
    protected Function<MetricRegistry, ConcurrentGauge> registerMetric(Metadata metadata, List<Tag> tags) {
        return metricRegistry -> metricRegistry.concurrentGauge(metadata, tags.toArray(new Tag[0]));
    }
}

