/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.kafkaconnector.CamelSinkConnector;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.camel.kafkaconnector.utils.CamelMainSupport;
import org.apache.camel.kafkaconnector.utils.TaskHelper;
import org.apache.camel.support.DefaultExchange;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.sink.SinkTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelSinkTask
extends SinkTask {
    public static final String KAFKA_RECORD_KEY_HEADER = "camel.kafka.connector.record.key";
    private static final String CAMEL_SINK_ENDPOINT_PROPERTIES_PREFIX = "camel.sink.endpoint.";
    private static final String CAMEL_SINK_PATH_PROPERTIES_PREFIX = "camel.sink.path.";
    private static Logger log = LoggerFactory.getLogger(CamelSinkTask.class);
    private static final String LOCAL_URL = "direct:start";
    private static final String HEADER_CAMEL_PREFIX = "CamelHeader";
    private static final String PROPERTY_CAMEL_PREFIX = "CamelProperty";
    private CamelMainSupport cms;
    private ProducerTemplate producer;
    private CamelSinkConnectorConfig config;

    public String version() {
        return new CamelSinkConnector().version();
    }

    public void start(Map<String, String> props) {
        try {
            log.info("Starting CamelSinkTask connector task");
            Map<String, String> actualProps = TaskHelper.mergeProperties(this.getDefaultConfig(), props);
            this.config = this.getCamelSinkConnectorConfig(actualProps);
            String remoteUrl = this.config.getString("camel.sink.url");
            String marshaller = this.config.getString("camel.sink.marshal");
            if (remoteUrl == null) {
                remoteUrl = TaskHelper.buildUrl(actualProps, this.config.getString("camel.sink.component"), CAMEL_SINK_ENDPOINT_PROPERTIES_PREFIX, CAMEL_SINK_PATH_PROPERTIES_PREFIX);
            }
            this.cms = new CamelMainSupport(actualProps, LOCAL_URL, remoteUrl, marshaller, null);
            this.producer = this.cms.createProducerTemplate();
            this.cms.start();
            log.info("CamelSinkTask connector task started");
        }
        catch (Exception e) {
            throw new ConnectException("Failed to create and start Camel context", (Throwable)e);
        }
    }

    protected CamelSinkConnectorConfig getCamelSinkConnectorConfig(Map<String, String> props) {
        return new CamelSinkConnectorConfig(props);
    }

    protected Map<String, String> getDefaultConfig() {
        return Collections.EMPTY_MAP;
    }

    protected static String getCamelSinkEndpointConfigPrefix() {
        return CAMEL_SINK_ENDPOINT_PROPERTIES_PREFIX;
    }

    protected static String getCamelSinkPathConfigPrefix() {
        return CAMEL_SINK_PATH_PROPERTIES_PREFIX;
    }

    public void put(Collection<SinkRecord> sinkRecords) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        DefaultExchange exchange = new DefaultExchange(this.producer.getCamelContext());
        for (SinkRecord record : sinkRecords) {
            headers.put(KAFKA_RECORD_KEY_HEADER, record.key());
            for (Header header : record.headers()) {
                if (header.key().startsWith(HEADER_CAMEL_PREFIX)) {
                    this.addHeader(headers, header);
                    continue;
                }
                if (!header.key().startsWith(PROPERTY_CAMEL_PREFIX)) continue;
                this.addProperty((Exchange)exchange, header);
            }
            exchange.getMessage().setHeaders(headers);
            exchange.getMessage().setBody(record.value());
            log.debug("Sending {} to {}", (Object)exchange, (Object)LOCAL_URL);
            this.producer.send(LOCAL_URL, (Exchange)exchange);
        }
    }

    public void stop() {
        try {
            log.info("Stopping CamelSinkTask connector task");
            this.cms.stop();
        }
        catch (Exception e) {
            throw new ConnectException("Failed to stop Camel context", (Throwable)e);
        }
        finally {
            log.info("CamelSinkTask connector task stopped");
        }
    }

    private void addHeader(Map<String, Object> map, Header singleHeader) {
        Schema schema = singleHeader.schema();
        if (schema.type().getName().equals(Schema.STRING_SCHEMA.type().getName())) {
            map.put(singleHeader.key(), (String)singleHeader.value());
        } else if (schema.type().getName().equalsIgnoreCase(Schema.BOOLEAN_SCHEMA.type().getName())) {
            map.put(singleHeader.key(), (Boolean)singleHeader.value());
        } else if (schema.type().getName().equalsIgnoreCase(Schema.INT32_SCHEMA.type().getName())) {
            map.put(singleHeader.key(), singleHeader.value());
        } else if (schema.type().getName().equalsIgnoreCase(Schema.BYTES_SCHEMA.type().getName())) {
            map.put(singleHeader.key(), (byte[])singleHeader.value());
        } else if (schema.type().getName().equalsIgnoreCase(Schema.FLOAT32_SCHEMA.type().getName())) {
            map.put(singleHeader.key(), Float.valueOf(((Float)singleHeader.value()).floatValue()));
        } else if (schema.type().getName().equalsIgnoreCase(Schema.FLOAT64_SCHEMA.type().getName())) {
            map.put(singleHeader.key(), (double)((Double)singleHeader.value()));
        } else if (schema.type().getName().equalsIgnoreCase(Schema.INT16_SCHEMA.type().getName())) {
            map.put(singleHeader.key(), (short)((Short)singleHeader.value()));
        } else if (schema.type().getName().equalsIgnoreCase(Schema.INT64_SCHEMA.type().getName())) {
            map.put(singleHeader.key(), (long)((Long)singleHeader.value()));
        } else if (schema.type().getName().equalsIgnoreCase(Schema.INT8_SCHEMA.type().getName())) {
            map.put(singleHeader.key(), (byte)((Byte)singleHeader.value()));
        } else if (schema.type().getName().equalsIgnoreCase(SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.STRING_SCHEMA).type().getName())) {
            map.put(singleHeader.key(), (Map)singleHeader.value());
        } else if (schema.type().getName().equalsIgnoreCase(SchemaBuilder.array((Schema)Schema.STRING_SCHEMA).type().getName())) {
            map.put(singleHeader.key(), (List)singleHeader.value());
        }
    }

    private void addProperty(Exchange exchange, Header singleHeader) {
        Schema schema = singleHeader.schema();
        if (schema.type().getName().equals(Schema.STRING_SCHEMA.type().getName())) {
            exchange.getProperties().put(singleHeader.key(), (String)singleHeader.value());
        } else if (schema.type().getName().equalsIgnoreCase(Schema.BOOLEAN_SCHEMA.type().getName())) {
            exchange.getProperties().put(singleHeader.key(), (Boolean)singleHeader.value());
        } else if (schema.type().getName().equalsIgnoreCase(Schema.INT32_SCHEMA.type().getName())) {
            exchange.getProperties().put(singleHeader.key(), singleHeader.value());
        } else if (schema.type().getName().equalsIgnoreCase(Schema.BYTES_SCHEMA.type().getName())) {
            exchange.getProperties().put(singleHeader.key(), (byte[])singleHeader.value());
        } else if (schema.type().getName().equalsIgnoreCase(Schema.FLOAT32_SCHEMA.type().getName())) {
            exchange.getProperties().put(singleHeader.key(), Float.valueOf(((Float)singleHeader.value()).floatValue()));
        } else if (schema.type().getName().equalsIgnoreCase(Schema.FLOAT64_SCHEMA.type().getName())) {
            exchange.getProperties().put(singleHeader.key(), Double.valueOf((Double)singleHeader.value()));
        } else if (schema.type().getName().equalsIgnoreCase(Schema.INT16_SCHEMA.type().getName())) {
            exchange.getProperties().put(singleHeader.key(), Short.valueOf((Short)singleHeader.value()));
        } else if (schema.type().getName().equalsIgnoreCase(Schema.INT64_SCHEMA.type().getName())) {
            exchange.getProperties().put(singleHeader.key(), Long.valueOf((Long)singleHeader.value()));
        } else if (schema.type().getName().equalsIgnoreCase(Schema.INT8_SCHEMA.type().getName())) {
            exchange.getProperties().put(singleHeader.key(), Byte.valueOf((Byte)singleHeader.value()));
        } else if (schema.type().getName().equalsIgnoreCase(SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.STRING_SCHEMA).type().getName())) {
            exchange.getProperties().put(singleHeader.key(), (Map)singleHeader.value());
        } else if (schema.type().getName().equalsIgnoreCase(SchemaBuilder.array((Schema)Schema.STRING_SCHEMA).type().getName())) {
            exchange.getProperties().put(singleHeader.key(), (List)singleHeader.value());
        }
    }

    public CamelMainSupport getCms() {
        return this.cms;
    }
}

