/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum RuleType {
    VALIDITY("VALIDITY"),
    COMPATIBILITY("COMPATIBILITY");

    private final String value;
    private static final Map<String, RuleType> CONSTANTS;

    private RuleType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static RuleType fromValue(String value) {
        RuleType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, RuleType>();
        for (RuleType c : RuleType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

