/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.text.SimpleDateFormat;
import org.apache.camel.api.management.mbean.BacklogTracerEventMessage;

public final class DefaultBacklogTracerEventMessage
implements BacklogTracerEventMessage {
    private static final long serialVersionUID = 1L;
    private final long uid;
    private final long timestamp;
    private final String routeId;
    private final String toNode;
    private final String exchangeId;
    private final String messageAsXml;

    public DefaultBacklogTracerEventMessage(long uid, long timestamp, String routeId, String toNode, String exchangeId, String messageAsXml) {
        this.uid = uid;
        this.timestamp = timestamp;
        this.routeId = routeId;
        this.toNode = toNode;
        this.exchangeId = exchangeId;
        this.messageAsXml = messageAsXml;
    }

    public long getUid() {
        return this.uid;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public String getToNode() {
        return this.toNode;
    }

    public String getExchangeId() {
        return this.exchangeId;
    }

    public String getMessageAsXml() {
        return this.messageAsXml;
    }

    public String toString() {
        return "DefaultBacklogTracerEventMessage[" + this.exchangeId + " at " + this.toNode + "]";
    }

    public String toXml(int indent) {
        StringBuilder prefix = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            prefix.append(" ");
        }
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)prefix).append("<").append("backlogTracerEventMessage").append(">\n");
        sb.append((CharSequence)prefix).append("  <uid>").append(this.uid).append("</uid>\n");
        String ts = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(this.timestamp);
        sb.append((CharSequence)prefix).append("  <timestamp>").append(ts).append("</timestamp>\n");
        sb.append((CharSequence)prefix).append("  <routeId>").append(this.routeId != null ? this.routeId : "").append("</routeId>\n");
        if (this.toNode != null) {
            sb.append((CharSequence)prefix).append("  <toNode>").append(this.toNode).append("</toNode>\n");
        } else {
            sb.append((CharSequence)prefix).append("  <toNode>").append(this.routeId).append("</toNode>\n");
        }
        sb.append((CharSequence)prefix).append("  <exchangeId>").append(this.exchangeId).append("</exchangeId>\n");
        sb.append((CharSequence)prefix).append(this.messageAsXml).append("\n");
        sb.append((CharSequence)prefix).append("</").append("backlogTracerEventMessage").append(">");
        return sb.toString();
    }
}

