/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Traceable;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.processor.ProcessorExchangePair;
import org.apache.camel.processor.aggregate.ShareUnitOfWorkAggregationStrategy;
import org.apache.camel.processor.aggregate.UseOriginalAggregationStrategy;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

public class Splitter
extends MulticastProcessor
implements AsyncProcessor,
Traceable {
    private final Expression expression;

    public Splitter(CamelContext camelContext, Route route, Expression expression, Processor destination, AggregationStrategy aggregationStrategy, boolean parallelProcessing, ExecutorService executorService, boolean shutdownExecutorService, boolean streaming, boolean stopOnException, long timeout, Processor onPrepare, boolean useSubUnitOfWork, boolean parallelAggregate) {
        this(camelContext, route, expression, destination, aggregationStrategy, parallelProcessing, executorService, shutdownExecutorService, streaming, stopOnException, timeout, onPrepare, useSubUnitOfWork, parallelAggregate, false);
    }

    public Splitter(CamelContext camelContext, Route route, Expression expression, Processor destination, AggregationStrategy aggregationStrategy, boolean parallelProcessing, ExecutorService executorService, boolean shutdownExecutorService, boolean streaming, boolean stopOnException, long timeout, Processor onPrepare, boolean useSubUnitOfWork, boolean parallelAggregate, boolean stopOnAggregateException) {
        super(camelContext, route, Collections.singleton(destination), aggregationStrategy, parallelProcessing, executorService, shutdownExecutorService, streaming, stopOnException, timeout, onPrepare, useSubUnitOfWork, parallelAggregate, stopOnAggregateException);
        this.expression = expression;
        ObjectHelper.notNull((Object)expression, (String)"expression");
        ObjectHelper.notNull((Object)destination, (String)"destination");
    }

    @Override
    public String getTraceLabel() {
        return "split[" + this.expression + "]";
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        this.expression.init(this.getCamelContext());
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        AggregationStrategy original;
        AggregationStrategy strategy = this.getAggregationStrategy();
        if (strategy instanceof UseOriginalAggregationStrategy) {
            original = (UseOriginalAggregationStrategy)strategy;
            AggregationStrategy clone = original.newInstance(exchange);
            if (this.isShareUnitOfWork()) {
                clone = new ShareUnitOfWorkAggregationStrategy(clone);
            }
            this.setAggregationStrategyOnExchange(exchange, clone);
        }
        if (strategy == null) {
            original = new UseOriginalAggregationStrategy(exchange, true);
            if (this.isShareUnitOfWork()) {
                original = new ShareUnitOfWorkAggregationStrategy(original);
            }
            this.setAggregationStrategyOnExchange(exchange, original);
        }
        return super.process(exchange, callback);
    }

    @Override
    protected Iterable<ProcessorExchangePair> createProcessorExchangePairs(Exchange exchange) throws Exception {
        Iterable<ProcessorExchangePair> answer;
        Object value = this.expression.evaluate(exchange, Object.class);
        if (exchange.getException() != null) {
            throw exchange.getException();
        }
        Iterable<ProcessorExchangePair> iterable = answer = this.isStreaming() ? this.createProcessorExchangePairsIterable(exchange, value) : this.createProcessorExchangePairsList(exchange, value);
        if (exchange.getException() != null) {
            throw exchange.getException();
        }
        return answer;
    }

    private Iterable<ProcessorExchangePair> createProcessorExchangePairsIterable(Exchange exchange, Object value) {
        return new SplitterIterable(exchange, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<ProcessorExchangePair> createProcessorExchangePairsList(Exchange exchange, Object value) {
        ArrayList<ProcessorExchangePair> result = new ArrayList<ProcessorExchangePair>();
        Iterable<ProcessorExchangePair> pairs = this.createProcessorExchangePairsIterable(exchange, value);
        try {
            for (ProcessorExchangePair pair : pairs) {
                if (pair == null) continue;
                result.add(pair);
            }
        }
        finally {
            if (pairs instanceof Closeable) {
                IOHelper.close((Closeable)((Closeable)((Object)pairs)), (String)"Splitter:ProcessorExchangePairs");
            }
        }
        return result;
    }

    @Override
    protected void updateNewExchange(Exchange exchange, int index, Iterable<ProcessorExchangePair> allPairs, boolean hasNext) {
        ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).setUnitOfWork(null);
        exchange.setProperty("CamelSplitIndex", (Object)index);
        if (allPairs instanceof Collection) {
            exchange.setProperty("CamelSplitSize", (Object)((Collection)allPairs).size());
        }
        if (hasNext) {
            exchange.setProperty("CamelSplitComplete", (Object)Boolean.FALSE);
        } else {
            exchange.setProperty("CamelSplitComplete", (Object)Boolean.TRUE);
            exchange.setProperty("CamelSplitSize", (Object)(index + 1));
        }
    }

    @Override
    protected Integer getExchangeIndex(Exchange exchange) {
        return (Integer)exchange.getProperty("CamelSplitIndex", Integer.class);
    }

    public Expression getExpression() {
        return this.expression;
    }

    private static Exchange copyAndPrepareSubExchange(Exchange exchange, boolean preserveExchangeId) {
        Exchange answer = ExchangeHelper.createCopy((Exchange)exchange, (boolean)preserveExchangeId);
        answer.getProperties().remove("CamelMessageHistory");
        return answer;
    }

    private final class SplitterIterable
    implements Iterable<ProcessorExchangePair>,
    Closeable {
        final Object value;
        final Iterator<?> iterator;
        private final Exchange copy;
        private final Route route;
        private final Exchange original;

        private SplitterIterable(Exchange exchange, Object value) {
            this.original = exchange;
            this.value = value;
            this.iterator = org.apache.camel.support.ObjectHelper.createIterator((Object)value);
            this.copy = Splitter.copyAndPrepareSubExchange(exchange, true);
            this.route = ExchangeHelper.getRoute((Exchange)exchange);
        }

        @Override
        public Iterator<ProcessorExchangePair> iterator() {
            return new Iterator<ProcessorExchangePair>(){
                private int index;
                private boolean closed;

                @Override
                public boolean hasNext() {
                    if (this.closed) {
                        return false;
                    }
                    boolean answer = SplitterIterable.this.iterator.hasNext();
                    if (!answer) {
                        this.closed = true;
                        try {
                            SplitterIterable.this.close();
                        }
                        catch (IOException e) {
                            throw new RuntimeCamelException("Scanner aborted because of an IOException!", (Throwable)e);
                        }
                    }
                    return answer;
                }

                @Override
                public ProcessorExchangePair next() {
                    Object part = SplitterIterable.this.iterator.next();
                    if (part != null) {
                        Exchange newExchange = ExchangeHelper.createCorrelatedCopy((Exchange)SplitterIterable.this.copy, (boolean)false);
                        if (newExchange.getProperty("CamelStreamCacheUnitOfWork") == null) {
                            newExchange.setProperty("CamelStreamCacheUnitOfWork", (Object)SplitterIterable.this.original.getUnitOfWork());
                        }
                        if (Splitter.this.isShareUnitOfWork()) {
                            Splitter.this.prepareSharedUnitOfWork(newExchange, SplitterIterable.this.copy);
                        }
                        if (part instanceof Message) {
                            newExchange.setIn((Message)part);
                        } else {
                            Message in = newExchange.getIn();
                            in.setBody(part);
                        }
                        return Splitter.this.createProcessorExchangePair(this.index++, Splitter.this.getProcessors().iterator().next(), newExchange, SplitterIterable.this.route);
                    }
                    return null;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Remove is not supported by this iterator");
                }
            };
        }

        @Override
        public void close() throws IOException {
            IOHelper.closeIterator((Object)this.value);
        }
    }
}

