/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import org.apache.camel.util.OrderedProperties;

public final class MainHelper {
    private MainHelper() {
    }

    public static String toEnvVar(String name) {
        return name.toUpperCase(Locale.US).replaceAll("[^\\w]", "-").replace('-', '_');
    }

    public static Optional<String> lookupPropertyFromSysOrEnv(String name) {
        String answer = System.getProperty(name);
        if (answer == null) {
            answer = System.getenv(MainHelper.toEnvVar(name));
        }
        return Optional.ofNullable(answer);
    }

    public static Properties loadEnvironmentVariablesAsProperties(String[] prefixes) {
        OrderedProperties answer = new OrderedProperties();
        if (prefixes == null || prefixes.length == 0) {
            return answer;
        }
        for (String prefix : prefixes) {
            String pk = prefix.toUpperCase(Locale.US).replaceAll("[^\\w]", "-");
            String pk2 = pk.replace('-', '_');
            System.getenv().forEach((arg_0, arg_1) -> MainHelper.lambda$loadEnvironmentVariablesAsProperties$0(pk, pk2, (Properties)answer, arg_0, arg_1));
        }
        return answer;
    }

    private static /* synthetic */ void lambda$loadEnvironmentVariablesAsProperties$0(String pk, String pk2, Properties answer, String k, String v) {
        if ((k = k.toUpperCase(Locale.US)).startsWith(pk) || k.startsWith(pk2)) {
            String key = k.toLowerCase(Locale.ENGLISH).replace('_', '.');
            answer.put(key, v);
        }
    }
}

