/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.model.DescriptionDefinition;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateParameterDefinition;
import org.apache.camel.spi.AsEndpointUri;
import org.apache.camel.spi.Metadata;

@Metadata(label="configuration")
@XmlRootElement(name="routeTemplate")
@XmlType(propOrder={"templateParameters", "route"})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RouteTemplateDefinition
extends OptionalIdentifiedDefinition {
    @XmlElement(name="templateParameter")
    private List<RouteTemplateParameterDefinition> templateParameters;
    @XmlElement(name="route", required=true)
    private RouteDefinition route = new RouteDefinition();

    public void setTemplateParameters(List<RouteTemplateParameterDefinition> templateParameters) {
        this.templateParameters = templateParameters;
    }

    public List<RouteTemplateParameterDefinition> getTemplateParameters() {
        return this.templateParameters;
    }

    public RouteDefinition getRoute() {
        return this.route;
    }

    public void setRoute(RouteDefinition route) {
        this.route = route;
    }

    public RouteDefinition from(@AsEndpointUri String uri) {
        return this.route.from(uri);
    }

    public RouteDefinition from(Endpoint endpoint) {
        return this.route.from(endpoint);
    }

    public RouteDefinition from(EndpointConsumerBuilder endpoint) {
        return this.route.from(endpoint);
    }

    public RouteDefinition route() {
        return this.route;
    }

    public RouteTemplateDefinition description(String text) {
        DescriptionDefinition def = new DescriptionDefinition();
        def.setText(text);
        this.setDescription(def);
        return this;
    }

    public RouteTemplateDefinition templateParameter(String name) {
        this.addTemplateParameter(name, null);
        return this;
    }

    public RouteTemplateDefinition templateParameter(String name, String defaultValue) {
        this.addTemplateParameter(name, defaultValue);
        return this;
    }

    public RouteTemplateDefinition templateParameter(String name, String defaultValue, String description) {
        this.addTemplateParameter(name, defaultValue, description);
        return this;
    }

    public RouteTemplateDefinition templateParameters(Map<String, String> parameters) {
        parameters.forEach(this::addTemplateParameter);
        return this;
    }

    public String getShortName() {
        return "routeTemplate";
    }

    public String getLabel() {
        return "RouteTemplate[" + this.route.getInput().getLabel() + "]";
    }

    private void addTemplateParameter(String name, String defaultValue) {
        this.addTemplateParameter(name, defaultValue, null);
    }

    private void addTemplateParameter(String name, String defaultValue, String description) {
        if (this.templateParameters == null) {
            this.templateParameters = new ArrayList<RouteTemplateParameterDefinition>();
        }
        this.templateParameters.add(new RouteTemplateParameterDefinition(name, defaultValue, description));
    }

    public RouteDefinition asRouteDefinition() {
        RouteDefinition copy = new RouteDefinition();
        copy.setInheritErrorHandler(this.route.isInheritErrorHandler());
        copy.setGroup(this.route.getGroup());
        copy.setStreamCache(this.route.getStreamCache());
        copy.setTrace(this.route.getTrace());
        copy.setMessageHistory(this.route.getMessageHistory());
        copy.setLogMask(this.route.getLogMask());
        copy.setDelayer(this.route.getDelayer());
        copy.setStartupOrder(this.route.getStartupOrder());
        copy.setRoutePolicies(this.route.getRoutePolicies());
        copy.setRoutePolicyRef(this.route.getRoutePolicyRef());
        copy.setShutdownRoute(this.route.getShutdownRoute());
        copy.setShutdownRunningTask(this.route.getShutdownRunningTask());
        copy.setErrorHandlerRef(this.route.getErrorHandlerRef());
        copy.setErrorHandlerFactory(this.route.getErrorHandlerFactory());
        copy.setInputType(this.route.getInputType());
        copy.setOutputType(this.route.getOutputType());
        copy.setRouteProperties(this.route.getRouteProperties());
        copy.setTemplate(true);
        copy.setInput(this.route.getInput());
        copy.setOutputs(this.route.getOutputs());
        if (this.route.getDescription() != null) {
            copy.setDescription(this.route.getDescription());
        } else {
            copy.setDescription(this.getDescription());
        }
        return copy;
    }
}

