/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.camel.spi.ReloadStrategy;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="reload", description="Console for reloading running Camel")
public class ReloadDevConsole
extends AbstractDevConsole {
    public static final String RELOAD = "reload";
    public static final String RELOAD_WAIT = "wait";
    private volatile ExecutorService reloadThread;

    public ReloadDevConsole() {
        super("camel", RELOAD, "Reload", "Console for reloading running Camel");
    }

    protected String doCallText(Map<String, Object> options) {
        boolean trigger = "true".equals(options.getOrDefault(RELOAD, "false"));
        boolean wait = "true".equals(options.getOrDefault(RELOAD_WAIT, "false"));
        StringBuilder sb = new StringBuilder();
        Set rs = this.getCamelContext().hasServices(ReloadStrategy.class);
        boolean failed = false;
        for (ReloadStrategy r : rs) {
            if (trigger) {
                int before = r.getFailedCounter();
                Future<?> f = this.getOrCreateReloadTask().submit(() -> r.onReload((Object)"ReloadDevConsole"));
                if (!wait) continue;
                try {
                    f.get(30L, TimeUnit.SECONDS);
                    failed |= r.getFailedCounter() > before;
                }
                catch (Exception exception) {}
                continue;
            }
            sb.append(String.format("\nReloadStrategy: %s", r.getClass().getName()));
            sb.append(String.format("\n    Reloaded: %s", r.getReloadCounter()));
            sb.append(String.format("\n    Failed: %s", r.getFailedCounter()));
        }
        if (trigger) {
            if (wait) {
                if (failed) {
                    sb.append("Status: Reload failed");
                } else {
                    sb.append("Status: Reload success");
                }
            } else {
                sb.append("Status: Reloading in progress");
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        boolean trigger = "true".equals(options.getOrDefault(RELOAD, "false"));
        boolean wait = "true".equals(options.getOrDefault(RELOAD_WAIT, "false"));
        JsonObject root = new JsonObject();
        JsonArray arr = new JsonArray();
        Set rs = this.getCamelContext().hasServices(ReloadStrategy.class);
        boolean failed = false;
        for (ReloadStrategy r : rs) {
            if (trigger) {
                int before = r.getFailedCounter();
                Future<?> f = this.getOrCreateReloadTask().submit(() -> r.onReload((Object)"ReloadDevConsole"));
                if (!wait) continue;
                try {
                    f.get(30L, TimeUnit.SECONDS);
                    failed |= r.getFailedCounter() > before;
                }
                catch (Exception exception) {}
                continue;
            }
            if (root.isEmpty()) {
                root.put((Object)"reloadStrategies", (Object)arr);
            }
            JsonObject jo = new JsonObject();
            arr.add((Object)jo);
            jo.put((Object)"className", (Object)r.getClass().getName());
            jo.put((Object)"reloaded", (Object)r.getReloadCounter());
            jo.put((Object)"failed", (Object)r.getFailedCounter());
        }
        if (trigger) {
            if (wait) {
                if (failed) {
                    root.put((Object)"status", (Object)"failed");
                } else {
                    root.put((Object)"status", (Object)"success");
                }
            } else {
                root.put((Object)"status", (Object)"reloading");
            }
        }
        return root;
    }

    protected ExecutorService getOrCreateReloadTask() {
        if (this.reloadThread == null) {
            this.reloadThread = this.getCamelContext().getExecutorServiceManager().newSingleThreadExecutor((Object)this, "ReloadOnDemand");
        }
        return this.reloadThread;
    }

    protected void doStop() throws Exception {
        if (this.reloadThread != null) {
            this.getCamelContext().getExecutorServiceManager().shutdown(this.reloadThread);
            this.reloadThread = null;
        }
    }
}

