/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.AsyncCallback;
import org.apache.camel.BeanScope;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.ConstantBeanHolder;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBeanProcessor
extends AsyncProcessorSupport {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBeanProcessor.class);
    private final BeanHolder beanHolder;
    private transient Processor processor;
    private transient Object bean;
    private transient boolean lookupProcessorDone;
    private final Object lock = new Object();
    private BeanScope scope;
    private String method;
    private boolean shorthandMethod;

    protected AbstractBeanProcessor(Object pojo, BeanInfo beanInfo) {
        this(new ConstantBeanHolder(pojo, beanInfo));
    }

    protected AbstractBeanProcessor(BeanHolder beanHolder) {
        this.beanHolder = beanHolder;
    }

    public String toString() {
        return "BeanProcessor[" + this.beanHolder + (String)(this.method != null ? "#" + this.method : "") + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        MethodInvocation invocation;
        BeanInfo beanInfo;
        Object bean;
        String explicitMethodName = (String)exchange.getIn().getHeader("CamelBeanMethodName", (Object)this.method, String.class);
        try {
            bean = this.beanHolder.getBean(exchange);
            beanInfo = this.beanHolder.getBeanInfo(bean);
            if (beanInfo == null) {
                beanInfo = this.beanHolder.getBeanInfo();
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
        if (this.allowProcessor(explicitMethodName, beanInfo)) {
            Processor target = this.getProcessor();
            if (target == null) {
                boolean allowCache;
                boolean bl = allowCache = this.scope == null || this.scope == BeanScope.Singleton;
                if (allowCache) {
                    if (!this.lookupProcessorDone) {
                        Object object = this.lock;
                        synchronized (object) {
                            this.lookupProcessorDone = true;
                            this.processor = target = (Processor)exchange.getContext().getTypeConverter().tryConvertTo(Processor.class, exchange, bean);
                        }
                    }
                } else {
                    target = (Processor)exchange.getContext().getTypeConverter().tryConvertTo(Processor.class, exchange, bean);
                }
            }
            if (target != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Using a custom adapter as bean invocation: {}", (Object)target);
                }
                try {
                    target.process(exchange);
                }
                catch (AssertionError | Exception e) {
                    exchange.setException((Throwable)e);
                }
                finally {
                    callback.done(true);
                }
                return true;
            }
        }
        Message in = exchange.getIn();
        if (explicitMethodName != null) {
            in.setHeader("CamelBeanMethodName", (Object)explicitMethodName);
        }
        try {
            invocation = beanInfo.createInvocation(bean, exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            boolean bl = true;
            return bl;
        }
        finally {
            if (explicitMethodName != null) {
                in.removeHeader("CamelBeanMethodName");
            }
        }
        if (invocation == null) {
            exchange.setException((Throwable)new IllegalStateException("No method invocation could be created, no matching method could be found on: " + bean));
            callback.done(true);
            return true;
        }
        return invocation.proceed(callback);
    }

    protected Processor getProcessor() {
        return this.processor;
    }

    protected BeanHolder getBeanHolder() {
        return this.beanHolder;
    }

    public Object getBean() {
        return this.beanHolder.getBean(null);
    }

    public String getMethod() {
        return this.method;
    }

    public BeanScope getScope() {
        return this.scope;
    }

    public void setScope(BeanScope scope) {
        this.scope = scope;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public boolean isShorthandMethod() {
        return this.shorthandMethod;
    }

    public void setShorthandMethod(boolean shorthandMethod) {
        this.shorthandMethod = shorthandMethod;
    }

    protected void doInit() throws Exception {
        if (this.beanHolder.supportProcessor() && this.allowProcessor(this.method, this.beanHolder.getBeanInfo())) {
            this.processor = this.beanHolder.getProcessor();
            ServiceHelper.initService((Object)this.processor);
        } else if (this.beanHolder instanceof ConstantBeanHolder) {
            try {
                this.bean = this.beanHolder.getBean(null);
                ServiceHelper.initService((Object)this.bean);
            }
            catch (NoSuchBeanException noSuchBeanException) {
                // empty catch block
            }
        }
    }

    protected void doStart() throws Exception {
        if (this.processor != null) {
            ServiceHelper.startService((Object)this.processor);
        } else if (this.bean != null) {
            ServiceHelper.startService((Object)this.bean);
        }
    }

    protected void doStop() throws Exception {
        if (this.processor != null) {
            ServiceHelper.stopService((Object)this.processor);
        } else if (this.bean != null) {
            ServiceHelper.stopService((Object)this.bean);
        }
    }

    protected void doShutdown() throws Exception {
        if (this.processor != null) {
            ServiceHelper.stopAndShutdownService((Object)this.processor);
        } else if (this.bean != null) {
            ServiceHelper.stopAndShutdownService((Object)this.bean);
        }
    }

    private boolean allowProcessor(String explicitMethodName, BeanInfo info) {
        if (explicitMethodName != null) {
            return false;
        }
        return !info.hasAnyMethodHandlerAnnotation();
    }
}

