/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.FactoryFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseServiceResolver<T> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final String factoryKey;
    protected final Class<T> factoryClass;
    protected final FactoryFinder factoryFinder;

    public BaseServiceResolver(String factoryKey, Class<T> factoryClass, FactoryFinder factoryFinder) {
        this.factoryKey = factoryKey;
        this.factoryClass = factoryClass;
        this.factoryFinder = factoryFinder;
    }

    public Optional<T> resolve(CamelContext context) {
        Class type = null;
        try {
            type = this.factoryFinder.findClass(this.factoryKey).orElse(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Found {}: {} via: {}{}", new Object[]{this.factoryClass.getSimpleName(), type.getName(), "META-INF/services/org/apache/camel/", this.factoryKey});
            }
            if (this.factoryClass.isAssignableFrom(type)) {
                T answer = this.factoryClass.cast(context.getInjector().newInstance(type, false));
                this.log.debug("Detected and using {}: {}", (Object)this.factoryClass.getSimpleName(), answer);
                return Optional.of(answer);
            }
            throw new IllegalArgumentException("Type is not a " + this.factoryClass.getSimpleName() + " implementation. Found: " + type.getName());
        }
        return Optional.empty();
    }
}

