/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.lucene;

import java.io.File;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.lucene.LuceneConfiguration;
import org.apache.camel.component.lucene.LuceneSearcher;
import org.apache.camel.processor.lucene.support.Hits;
import org.apache.camel.support.DefaultProducer;
import org.apache.lucene.analysis.Analyzer;

public class LuceneQueryProducer
extends DefaultProducer {
    LuceneConfiguration config;
    LuceneSearcher searcher;
    Analyzer analyzer;
    File indexDirectory;
    int maxNumberOfHits;
    int totalHitsThreshold;

    public LuceneQueryProducer(Endpoint endpoint, LuceneConfiguration config) throws Exception {
        super(endpoint);
        this.config = config;
        this.indexDirectory = config.getIndexDir();
        this.analyzer = config.getAnalyzer();
        this.maxNumberOfHits = config.getMaxHits();
    }

    public void doStart() throws Exception {
        this.searcher = new LuceneSearcher();
        super.doStart();
    }

    public void doStop() throws Exception {
        this.searcher.close();
        super.doStop();
    }

    public void process(Exchange exchange) throws Exception {
        boolean isReturnLuceneDocs;
        String phrase = (String)exchange.getIn().getHeader("QUERY", String.class);
        String returnLuceneDocs = (String)exchange.getIn().getHeader("RETURN_LUCENE_DOCS", String.class);
        boolean bl = isReturnLuceneDocs = returnLuceneDocs != null && returnLuceneDocs.equalsIgnoreCase("true");
        if (phrase == null) {
            throw new IllegalArgumentException("SearchPhrase for LucenePhraseQuerySearcher not set. Set the Header value: QUERY");
        }
        this.searcher.open(this.indexDirectory, this.analyzer);
        Hits hits = this.searcher.search(phrase, this.maxNumberOfHits, this.totalHitsThreshold, isReturnLuceneDocs);
        exchange.getIn().setBody((Object)hits);
    }

    public LuceneConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(LuceneConfiguration config) {
        this.config = config;
    }
}

