/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.lucene;

import java.io.File;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.lucene.LuceneComponent;
import org.apache.camel.component.lucene.LuceneConfiguration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;
import org.apache.lucene.analysis.Analyzer;

public class LuceneComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private LuceneConfiguration getOrCreateConfiguration(LuceneComponent target) {
        if (target.getConfig() == null) {
            target.setConfig(new LuceneConfiguration());
        }
        return target.getConfig();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        LuceneComponent target = (LuceneComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "analyzer": {
                this.getOrCreateConfiguration(target).setAnalyzer((Analyzer)LuceneComponentConfigurer.property((CamelContext)camelContext, Analyzer.class, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)LuceneComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "config": {
                target.setConfig((LuceneConfiguration)LuceneComponentConfigurer.property((CamelContext)camelContext, LuceneConfiguration.class, (Object)value));
                return true;
            }
            case "indexdir": 
            case "indexDir": {
                this.getOrCreateConfiguration(target).setIndexDir((File)LuceneComponentConfigurer.property((CamelContext)camelContext, File.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)LuceneComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maxhits": 
            case "maxHits": {
                this.getOrCreateConfiguration(target).setMaxHits((Integer)LuceneComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "srcdir": 
            case "srcDir": {
                this.getOrCreateConfiguration(target).setSrcDir((File)LuceneComponentConfigurer.property((CamelContext)camelContext, File.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        CaseInsensitiveMap answer = new CaseInsensitiveMap();
        answer.put("analyzer", Analyzer.class);
        answer.put("basicPropertyBinding", Boolean.TYPE);
        answer.put("config", LuceneConfiguration.class);
        answer.put("indexDir", File.class);
        answer.put("lazyStartProducer", Boolean.TYPE);
        answer.put("maxHits", Integer.TYPE);
        answer.put("srcDir", File.class);
        return answer;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        LuceneComponent target = (LuceneComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "analyzer": {
                return this.getOrCreateConfiguration(target).getAnalyzer();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "config": {
                return target.getConfig();
            }
            case "indexdir": 
            case "indexDir": {
                return this.getOrCreateConfiguration(target).getIndexDir();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "maxhits": 
            case "maxHits": {
                return this.getOrCreateConfiguration(target).getMaxHits();
            }
            case "srcdir": 
            case "srcDir": {
                return this.getOrCreateConfiguration(target).getSrcDir();
            }
        }
        return null;
    }
}

