/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.geo.EdgeTree;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.index.PointValues;

public final class Polygon2D
extends EdgeTree {
    private final Polygon2D holes;
    private final AtomicBoolean containsBoundary = new AtomicBoolean(false);

    private Polygon2D(Polygon polygon, Polygon2D holes) {
        super(polygon.minLat, polygon.maxLat, polygon.minLon, polygon.maxLon, polygon.getPolyLats(), polygon.getPolyLons());
        this.holes = holes;
    }

    public boolean contains(double latitude, double longitude) {
        if (latitude <= this.maxY && longitude <= this.maxX) {
            if (this.componentContains(latitude, longitude)) {
                return true;
            }
            if (this.left != null && ((Polygon2D)this.left).contains(latitude, longitude)) {
                return true;
            }
            if (this.right != null && (!this.splitX && latitude >= this.minLat || this.splitX && longitude >= this.minLon) && ((Polygon2D)this.right).contains(latitude, longitude)) {
                return true;
            }
        }
        return false;
    }

    private boolean componentContains(double latitude, double longitude) {
        if (latitude < this.minLat || latitude > this.maxLat || longitude < this.minLon || longitude > this.maxLon) {
            return false;
        }
        this.containsBoundary.set(false);
        if (Polygon2D.contains(this.tree, latitude, longitude, this.containsBoundary)) {
            return this.holes == null || !this.holes.contains(latitude, longitude);
        }
        return false;
    }

    @Override
    protected PointValues.Relation componentRelate(double minLat, double maxLat, double minLon, double maxLon) {
        int numCorners;
        if (this.holes != null) {
            PointValues.Relation holeRelation = this.holes.relate(minLat, maxLat, minLon, maxLon);
            if (holeRelation == PointValues.Relation.CELL_CROSSES_QUERY) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            if (holeRelation == PointValues.Relation.CELL_INSIDE_QUERY) {
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
        }
        if ((numCorners = this.numberOfCorners(minLat, maxLat, minLon, maxLon)) == 4) {
            if (this.tree.crossesBox(minLat, maxLat, minLon, maxLon, false)) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
        if (numCorners == 0) {
            if (minLat >= this.tree.lat1 && maxLat <= this.tree.lat1 && minLon >= this.tree.lon2 && maxLon <= this.tree.lon2) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            if (this.tree.crossesBox(minLat, maxLat, minLon, maxLon, false)) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        return PointValues.Relation.CELL_CROSSES_QUERY;
    }

    @Override
    protected PointValues.Relation componentRelateTriangle(double ax, double ay, double bx, double by, double cx, double cy) {
        if (this.holes != null) {
            PointValues.Relation holeRelation = this.holes.relateTriangle(ax, ay, bx, by, cx, cy);
            if (holeRelation == PointValues.Relation.CELL_CROSSES_QUERY) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            if (holeRelation == PointValues.Relation.CELL_INSIDE_QUERY) {
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
        }
        if (ax == bx && bx == cx && ay == by && by == cy) {
            return this.contains(ay, ax) ? PointValues.Relation.CELL_INSIDE_QUERY : PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (ax == cx && ay == cy || bx == cx && by == cy) {
            return this.relateIndexedLineSegment(ax, ay, bx, by);
        }
        return this.relateIndexedTriangle(ax, ay, bx, by, cx, cy);
    }

    private PointValues.Relation relateIndexedLineSegment(double a2x, double a2y, double b2x, double b2y) {
        int numCorners = 0;
        if (this.componentContains(a2y, a2x)) {
            ++numCorners;
        }
        if (this.componentContains(b2y, b2x)) {
            ++numCorners;
        }
        if (numCorners == 2) {
            if (this.tree.crossesLine(a2x, a2y, b2x, b2y)) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
        if (numCorners == 0) {
            if (this.tree.crossesLine(a2x, a2y, b2x, b2y)) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        return PointValues.Relation.CELL_CROSSES_QUERY;
    }

    private PointValues.Relation relateIndexedTriangle(double ax, double ay, double bx, double by, double cx, double cy) {
        int numCorners = this.numberOfTriangleCorners(ax, ay, bx, by, cx, cy);
        if (numCorners == 3) {
            if (this.tree.crossesTriangle(ax, ay, bx, by, cx, cy)) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
        if (numCorners == 0) {
            if (Polygon2D.pointInTriangle(this.tree.lon1, this.tree.lat1, ax, ay, bx, by, cx, cy)) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            if (this.tree.crossesTriangle(ax, ay, bx, by, cx, cy)) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        return PointValues.Relation.CELL_CROSSES_QUERY;
    }

    private int numberOfTriangleCorners(double ax, double ay, double bx, double by, double cx, double cy) {
        int containsCount = 0;
        if (this.componentContains(ay, ax)) {
            ++containsCount;
        }
        if (this.componentContains(by, bx)) {
            ++containsCount;
        }
        if (containsCount == 1) {
            return containsCount;
        }
        if (this.componentContains(cy, cx)) {
            ++containsCount;
        }
        return containsCount;
    }

    private int numberOfCorners(double minLat, double maxLat, double minLon, double maxLon) {
        int containsCount = 0;
        if (this.componentContains(minLat, minLon)) {
            ++containsCount;
        }
        if (this.componentContains(minLat, maxLon)) {
            ++containsCount;
        }
        if (containsCount == 1) {
            return containsCount;
        }
        if (this.componentContains(maxLat, maxLon)) {
            ++containsCount;
        }
        if (containsCount == 2) {
            return containsCount;
        }
        if (this.componentContains(maxLat, minLon)) {
            ++containsCount;
        }
        return containsCount;
    }

    public static Polygon2D create(Polygon ... polygons) {
        EdgeTree[] components = new Polygon2D[polygons.length];
        for (int i = 0; i < components.length; ++i) {
            Polygon gon = polygons[i];
            Polygon[] gonHoles = gon.getHoles();
            Polygon2D holes = null;
            if (gonHoles.length > 0) {
                holes = Polygon2D.create(gonHoles);
            }
            components[i] = new Polygon2D(gon, holes);
        }
        return (Polygon2D)Polygon2D.createTree(components, 0, components.length - 1, false);
    }

    private static boolean contains(EdgeTree.Edge edge, double lat, double lon, AtomicBoolean isOnEdge) {
        boolean res = false;
        if (!isOnEdge.get() && lat <= edge.max) {
            if (lat == edge.lat1 && lat == edge.lat2 || (lat <= edge.lat1 && lat >= edge.lat2) != (lat >= edge.lat1 && lat <= edge.lat2)) {
                if (lon == edge.lon1 && lon == edge.lon2 || (lon <= edge.lon1 && lon >= edge.lon2) != (lon >= edge.lon1 && lon <= edge.lon2) && GeoUtils.orient(edge.lon1, edge.lat1, edge.lon2, edge.lat2, lon, lat) == 0) {
                    isOnEdge.set(true);
                    return true;
                }
                if (edge.lat1 > lat != edge.lat2 > lat) {
                    boolean bl = res = lon < (edge.lon2 - edge.lon1) * (lat - edge.lat1) / (edge.lat2 - edge.lat1) + edge.lon1;
                }
            }
            if (edge.left != null) {
                res ^= Polygon2D.contains(edge.left, lat, lon, isOnEdge);
            }
            if (edge.right != null && lat >= edge.low) {
                res ^= Polygon2D.contains(edge.right, lat, lon, isOnEdge);
            }
        }
        return isOnEdge.get() || res;
    }
}

