/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.client.RemoteTablet;
import org.apache.kudu.shaded.com.google.common.base.MoreObjects;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.shaded.com.google.common.base.Ticker;
import org.apache.kudu.shaded.com.google.common.primitives.UnsignedBytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@ThreadSafe
class TableLocationsCache {
    private static final Logger LOG = LoggerFactory.getLogger(TableLocationsCache.class);
    private static final Comparator<byte[]> COMPARATOR = UnsignedBytes.lexicographicalComparator();
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    @GuardedBy(value="rwl")
    private final NavigableMap<byte[], Entry> entries = new TreeMap<byte[], Entry>(COMPARATOR);
    @InterfaceAudience.LimitedPrivate(value={"Test"})
    static Ticker ticker = Ticker.systemTicker();

    TableLocationsCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry get(byte[] partitionKey) {
        Map.Entry<byte[], Entry> entry;
        if (partitionKey == null) {
            this.rwl.readLock().lock();
            try {
                Preconditions.checkState(this.entries.size() <= 1);
                Entry entry2 = (Entry)this.entries.get(AsyncKuduClient.EMPTY_ARRAY);
                return entry2;
            }
            finally {
                this.rwl.readLock().unlock();
            }
        }
        this.rwl.readLock().lock();
        try {
            entry = this.entries.floorEntry(partitionKey);
        }
        finally {
            this.rwl.readLock().unlock();
        }
        if (entry == null || entry.getValue().getUpperBoundPartitionKey().length > 0 && Bytes.memcmp(partitionKey, entry.getValue().getUpperBoundPartitionKey()) >= 0 || entry.getValue().isStale()) {
            return null;
        }
        return entry.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheTabletLocations(List<RemoteTablet> tablets, byte[] requestPartitionKey, int requestedBatchSize, long ttl) {
        long deadline = ticker.read() + ttl * TimeUnit.MILLISECONDS.toNanos(1L);
        if (requestPartitionKey == null) {
            Preconditions.checkArgument(tablets.size() == 1);
            Entry entry = Entry.tablet(tablets.get(0), TimeUnit.DAYS.toMillis(1L));
            this.rwl.writeLock().lock();
            try {
                this.entries.clear();
                this.entries.put(AsyncKuduClient.EMPTY_ARRAY, entry);
            }
            finally {
                this.rwl.writeLock().unlock();
            }
            return;
        }
        ArrayList<Entry> newEntries = new ArrayList<Entry>();
        if (tablets.isEmpty()) {
            newEntries.add(Entry.nonCoveredRange(AsyncKuduClient.EMPTY_ARRAY, AsyncKuduClient.EMPTY_ARRAY, deadline));
        } else {
            byte[] firstLowerBound = tablets.get(0).getPartition().getPartitionKeyStart();
            if (Bytes.memcmp(requestPartitionKey, firstLowerBound) < 0) {
                newEntries.add(Entry.nonCoveredRange(AsyncKuduClient.EMPTY_ARRAY, firstLowerBound, deadline));
            }
            byte[] lastUpperBound = firstLowerBound;
            for (RemoteTablet tablet : tablets) {
                byte[] tabletLowerBound = tablet.getPartition().getPartitionKeyStart();
                byte[] tabletUpperBound = tablet.getPartition().getPartitionKeyEnd();
                if (Bytes.memcmp(lastUpperBound, tabletLowerBound) < 0) {
                    newEntries.add(Entry.nonCoveredRange(lastUpperBound, tabletLowerBound, deadline));
                }
                lastUpperBound = tabletUpperBound;
                newEntries.add(Entry.tablet(tablet, deadline));
            }
            if (lastUpperBound.length > 0 && tablets.size() < requestedBatchSize) {
                newEntries.add(Entry.nonCoveredRange(lastUpperBound, AsyncKuduClient.EMPTY_ARRAY, deadline));
            }
        }
        byte[] discoveredlowerBound = ((Entry)newEntries.get(0)).getLowerBoundPartitionKey();
        byte[] discoveredUpperBound = ((Entry)newEntries.get(newEntries.size() - 1)).getUpperBoundPartitionKey();
        LOG.debug("Discovered table locations:\t{}", (Object)newEntries);
        this.rwl.writeLock().lock();
        try {
            Map.Entry<byte[], Entry> floorEntry = this.entries.floorEntry(discoveredlowerBound);
            if (floorEntry != null && Bytes.memcmp(requestPartitionKey, floorEntry.getValue().getUpperBoundPartitionKey()) < 0) {
                discoveredlowerBound = floorEntry.getKey();
            }
            NavigableMap<byte[], Entry> overlappingEntries = this.entries.tailMap(discoveredlowerBound, true);
            if (discoveredUpperBound.length > 0) {
                overlappingEntries = overlappingEntries.headMap(discoveredUpperBound, false);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Existing table locations:\t\t{}", (Object)this.entries.values());
                LOG.trace("Removing table locations:\t\t{}", (Object)overlappingEntries.values());
            }
            overlappingEntries.clear();
            for (Entry entry : newEntries) {
                this.entries.put(entry.getLowerBoundPartitionKey(), entry);
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    public void clearNonCoveredRangeEntries() {
        this.rwl.writeLock().lock();
        try {
            Iterator it = this.entries.entrySet().iterator();
            while (it.hasNext()) {
                if (!((Entry)it.next().getValue()).isNonCoveredRange()) continue;
                it.remove();
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    public String toString() {
        this.rwl.readLock().lock();
        try {
            String string = this.entries.values().toString();
            return string;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    public static class Entry {
        private final RemoteTablet tablet;
        private final byte[] lowerBoundPartitionKey;
        private final byte[] upperBoundPartitionKey;
        private final long deadline;

        private Entry(RemoteTablet tablet, byte[] lowerBoundPartitionKey, byte[] upperBoundPartitionKey, long deadline) {
            this.tablet = tablet;
            this.lowerBoundPartitionKey = lowerBoundPartitionKey;
            this.upperBoundPartitionKey = upperBoundPartitionKey;
            this.deadline = deadline;
        }

        public static Entry nonCoveredRange(byte[] lowerBoundPartitionKey, byte[] upperBoundPartitionKey, long deadline) {
            return new Entry(null, lowerBoundPartitionKey, upperBoundPartitionKey, deadline);
        }

        public static Entry tablet(RemoteTablet tablet, long deadline) {
            return new Entry(tablet, null, null, deadline);
        }

        public boolean isNonCoveredRange() {
            return this.tablet == null;
        }

        public RemoteTablet getTablet() {
            return this.tablet;
        }

        public byte[] getLowerBoundPartitionKey() {
            return this.tablet == null ? this.lowerBoundPartitionKey : this.tablet.getPartition().getPartitionKeyStart();
        }

        public byte[] getUpperBoundPartitionKey() {
            return this.tablet == null ? this.upperBoundPartitionKey : this.tablet.getPartition().getPartitionKeyEnd();
        }

        long ttl() {
            return TimeUnit.NANOSECONDS.toMillis(this.deadline - ticker.read());
        }

        public boolean isStale() {
            return this.ttl() <= 0L;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.isNonCoveredRange() ? "NonCoveredRange" : "Tablet").omitNullValues().add("lowerBoundPartitionKey", Bytes.hex(this.getLowerBoundPartitionKey())).add("upperBoundPartitionKey", Bytes.hex(this.getUpperBoundPartitionKey())).add("ttl", this.ttl()).add("tablet", this.tablet).toString();
        }
    }
}

