/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.io.IOException;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.AsyncKuduSession;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.shaded.com.google.protobuf.CodedInputStream;
import org.apache.kudu.shaded.com.google.protobuf.CodedOutputStream;
import org.apache.kudu.transactions.Transactions;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class KuduTransaction
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(KuduTransaction.class);
    private static final SerializationOptions defaultSerializationOptions = new SerializationOptions();
    private final AsyncKuduClient client;
    private long txnId = -1L;
    private int keepaliveMillis = 0;
    private boolean keepaliveEnabled = true;
    private boolean isInFlight = false;
    private final Object isInFlightSync = new Object();

    KuduTransaction(AsyncKuduClient client) {
        Preconditions.checkArgument(client != null);
        this.client = client;
    }

    KuduTransaction(AsyncKuduClient client, long txnId, int keepaliveMillis, boolean keepaliveEnabled) {
        Preconditions.checkArgument(client != null);
        Preconditions.checkArgument(txnId > -1L);
        Preconditions.checkArgument(keepaliveMillis >= 0);
        this.client = client;
        this.txnId = txnId;
        this.keepaliveMillis = keepaliveMillis;
        this.keepaliveEnabled = keepaliveEnabled;
        this.isInFlight = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void begin() throws KuduException {
        Object object = this.isInFlightSync;
        synchronized (object) {
            Preconditions.checkState(!this.isInFlight);
        }
        object = this.isInFlightSync;
        synchronized (object) {
            this.isInFlight = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncKuduSession newAsyncKuduSession() {
        Object object = this.isInFlightSync;
        synchronized (object) {
            Preconditions.checkState(this.isInFlight);
        }
        return new AsyncKuduSession(this.client, this.txnId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KuduSession newKuduSession() {
        Object object = this.isInFlightSync;
        synchronized (object) {
            Preconditions.checkState(this.isInFlight);
        }
        return new KuduSession(new AsyncKuduSession(this.client, this.txnId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(boolean wait) throws KuduException {
        Preconditions.checkState(this.isInFlight);
        Object object = this.isInFlightSync;
        synchronized (object) {
            this.isInFlight = false;
        }
    }

    public boolean isCommitComplete() throws KuduException {
        Preconditions.checkState(!this.isInFlight);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws KuduException {
        Preconditions.checkState(this.isInFlight, "transaction is not open for this handle");
        Object object = this.isInFlightSync;
        synchronized (object) {
            this.isInFlight = false;
        }
    }

    public byte[] serialize(SerializationOptions options) throws IOException {
        LOG.debug("serializing handle for transaction ID {}", (Object)this.txnId);
        Preconditions.checkState(this.txnId != -1L, "invalid transaction handle");
        Transactions.TxnTokenPB.Builder b = Transactions.TxnTokenPB.newBuilder();
        b.setTxnId(this.txnId);
        b.setEnableKeepalive(options.isKeepaliveEnabled());
        b.setKeepaliveMillis(this.keepaliveMillis);
        Transactions.TxnTokenPB message = b.build();
        byte[] buf = new byte[message.getSerializedSize()];
        CodedOutputStream cos = CodedOutputStream.newInstance(buf);
        message.writeTo(cos);
        cos.flush();
        return buf;
    }

    public byte[] serialize() throws IOException {
        return this.serialize(defaultSerializationOptions);
    }

    public static KuduTransaction deserialize(byte[] buf, AsyncKuduClient client) throws IOException {
        Transactions.TxnTokenPB pb = Transactions.TxnTokenPB.parseFrom(CodedInputStream.newInstance(buf));
        long txnId = pb.getTxnId();
        int keepaliveMillis = pb.getKeepaliveMillis();
        boolean keepaliveEnabled = pb.hasEnableKeepalive() && pb.getEnableKeepalive();
        return new KuduTransaction(client, txnId, keepaliveMillis, keepaliveEnabled);
    }

    @Override
    public void close() {
        try {
            if (this.keepaliveEnabled) {
                LOG.debug("stopping keepalive heartbeating for transaction ID {}", (Object)this.txnId);
            }
        }
        catch (Exception e) {
            LOG.error("exception while automatically rolling back a transaction", e);
        }
    }

    public static class SerializationOptions {
        private boolean enableKeepalive = false;

        SerializationOptions() {
        }

        public boolean isKeepaliveEnabled() {
            return this.enableKeepalive;
        }

        public SerializationOptions setEnableKeepalive(boolean enableKeepalive) {
            this.enableKeepalive = enableKeepalive;
            return this;
        }
    }
}

