/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.IsCreateTableDoneResponse;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.master.Master;
import org.apache.kudu.shaded.com.google.protobuf.Message;
import org.apache.kudu.shaded.org.jboss.netty.util.Timer;
import org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class IsCreateTableDoneRequest
extends KuduRpc<IsCreateTableDoneResponse> {
    private final Master.TableIdentifierPB.Builder tableId;

    IsCreateTableDoneRequest(KuduTable masterTable, Master.TableIdentifierPB.Builder tableId, Timer timer, long timeoutMillis) {
        super(masterTable, timer, timeoutMillis);
        this.tableId = tableId;
    }

    @Override
    String serviceName() {
        return "kudu.master.MasterService";
    }

    @Override
    String method() {
        return "IsCreateTableDone";
    }

    @Override
    Pair<IsCreateTableDoneResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws KuduException {
        Master.IsCreateTableDoneResponsePB.Builder builder = Master.IsCreateTableDoneResponsePB.newBuilder();
        IsCreateTableDoneRequest.readProtobuf(callResponse.getPBMessage(), builder);
        IsCreateTableDoneResponse resp = new IsCreateTableDoneResponse(this.timeoutTracker.getElapsedMillis(), tsUUID, builder.getDone());
        return new Pair<IsCreateTableDoneResponse, Object>(resp, builder.hasError() ? builder.getError() : null);
    }

    @Override
    Message createRequestPB() {
        Master.IsCreateTableDoneRequestPB.Builder builder = Master.IsCreateTableDoneRequestPB.newBuilder();
        builder.setTable(this.tableId);
        return builder.build();
    }
}

