/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kudu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduScannerIterator;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.RowResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KuduUtils {
    private static final Logger LOG = LoggerFactory.getLogger(KuduUtils.class);

    private KuduUtils() {
    }

    public static List<Map<String, Object>> scannerToList(KuduTable table, KuduScanner scanner) {
        KuduScannerIterator it = scanner.iterator();
        ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>();
        while (it.hasNext()) {
            RowResult row = it.next();
            HashMap<String, Object> r = new HashMap<String, Object>();
            res.add(r);
            for (ColumnSchema columnSchema : table.getSchema().getColumns()) {
                String name = columnSchema.getName();
                r.put(name, row.getObject(name));
            }
        }
        return res;
    }

    public static List<Map<String, Object>> doScan(String tableName, KuduClient connection) throws KuduException {
        LOG.trace("Scanning table {}", (Object)tableName);
        KuduTable table = connection.openTable(tableName);
        ArrayList<String> projectColumns = new ArrayList<String>(1);
        for (ColumnSchema columnSchema : table.getSchema().getColumns()) {
            projectColumns.add(columnSchema.getName());
        }
        KuduScanner scanner = ((KuduScanner.KuduScannerBuilder)connection.newScannerBuilder(table).setProjectedColumnNames(projectColumns)).build();
        return KuduUtils.scannerToList(table, scanner);
    }
}

