/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.informers.ListerWatcher;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.SharedInformerEventListener;
import io.fabric8.kubernetes.client.informers.impl.DefaultSharedIndexInformer;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.kubernetes.internal.KubernetesDeserializer;
import io.fabric8.kubernetes.model.annotation.ApiGroup;
import io.fabric8.kubernetes.model.annotation.ApiVersion;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import okhttp3.OkHttpClient;

public class SharedInformerFactory
extends BaseOperation {
    private Map<Type, SharedIndexInformer> informers;
    private Map<Type, Future> startedInformers;
    private ExecutorService informerExecutor;
    private BaseOperation baseOperation;
    private ConcurrentLinkedQueue<SharedInformerEventListener> eventListeners;

    public SharedInformerFactory(ExecutorService threadPool, OkHttpClient okHttpClient, Config configuration) {
        super(new OperationContext().withOkhttpClient(okHttpClient).withConfig(configuration));
        this.informerExecutor = threadPool;
        this.informers = new HashMap<Type, SharedIndexInformer>();
        this.startedInformers = new HashMap<Type, Future>();
        this.baseOperation = this.newInstance(this.context);
        this.eventListeners = new ConcurrentLinkedQueue();
    }

    public synchronized <T extends HasMetadata, L extends KubernetesResourceList<T>> SharedIndexInformer<T> sharedIndexInformerFor(Class<T> apiTypeClass, Class<L> apiListTypeClass, long resyncPeriodInMillis) {
        return this.sharedIndexInformerFor(apiTypeClass, apiListTypeClass, this.context.withApiGroupName(Utils.getAnnotationValue(apiTypeClass, ApiGroup.class)).withApiGroupVersion(Utils.getAnnotationValue(apiTypeClass, ApiVersion.class)).withPlural(Utils.getPluralFromKind(apiTypeClass.getSimpleName())), resyncPeriodInMillis);
    }

    public synchronized <T extends HasMetadata, L extends KubernetesResourceList<T>> SharedIndexInformer<T> sharedIndexInformerForCustomResource(CustomResourceDefinitionContext customResourceContext, Class<T> apiTypeClass, Class<L> apiListTypeClass, long resyncPeriodInMillis) {
        return this.sharedIndexInformerFor(apiTypeClass, apiListTypeClass, this.context.withApiGroupVersion(customResourceContext.getVersion()).withApiGroupName(customResourceContext.getGroup()).withPlural(customResourceContext.getPlural()), resyncPeriodInMillis);
    }

    public synchronized <T extends HasMetadata, L extends KubernetesResourceList<T>> SharedIndexInformer<T> sharedIndexInformerForCustomResource(CustomResourceDefinitionContext customResourceContext, Class<T> apiTypeClass, Class<L> apiListTypeClass, OperationContext operationContext, long resyncPeriodInMillis) {
        return this.sharedIndexInformerFor(apiTypeClass, apiListTypeClass, this.context.withApiGroupVersion(customResourceContext.getVersion()).withApiGroupName(customResourceContext.getGroup()).withPlural(customResourceContext.getPlural()).withOperationContext(operationContext), resyncPeriodInMillis);
    }

    public synchronized <T extends HasMetadata, L extends KubernetesResourceList<T>> SharedIndexInformer<T> sharedIndexInformerFor(Class<T> apiTypeClass, Class<L> apiListTypeClass, OperationContext operationContext, long resyncPeriodInMillis) {
        ListerWatcher<T, L> listerWatcher = this.listerWatcherFor(apiTypeClass, apiListTypeClass);
        DefaultSharedIndexInformer<T, L> informer = new DefaultSharedIndexInformer<T, L>(apiTypeClass, listerWatcher, resyncPeriodInMillis, this.context.withApiGroupName(Utils.getAnnotationValue(apiTypeClass, ApiGroup.class)).withApiGroupVersion(Utils.getAnnotationValue(apiTypeClass, ApiVersion.class)).withPlural(Utils.getPluralFromKind(apiTypeClass.getSimpleName())).withOperationContext(operationContext), this.eventListeners);
        this.informers.put(apiTypeClass, informer);
        return informer;
    }

    private <T extends HasMetadata, L extends KubernetesResourceList<T>> ListerWatcher<T, L> listerWatcherFor(final Class<T> apiTypeClass, final Class<L> apiListTypeClass) {
        return new ListerWatcher<T, L>(){

            @Override
            public L list(ListOptions params, String namespace, OperationContext context) throws KubernetesClientException {
                BaseOperation listBaseOperation = SharedInformerFactory.this.baseOperation.newInstance(context.withNamespace(namespace));
                listBaseOperation.setType(apiTypeClass);
                listBaseOperation.setListType(apiListTypeClass);
                return listBaseOperation.list();
            }

            @Override
            public Watch watch(ListOptions params, String namespace, OperationContext context, Watcher<T> resourceWatcher) throws KubernetesClientException {
                BaseOperation watchBaseOperation = SharedInformerFactory.this.baseOperation.newInstance(context);
                watchBaseOperation.setType(apiTypeClass);
                watchBaseOperation.setListType(apiListTypeClass);
                if (context.getApiGroupName() != null && context.getApiGroupVersion() != null) {
                    String apiGroupNameAndVersion = context.getApiGroupName() + (context.getApiGroupName().endsWith("/") ? context.getApiGroupVersion() : "/" + context.getApiGroupVersion());
                    KubernetesDeserializer.registerCustomKind((String)apiGroupNameAndVersion, (String)apiTypeClass.getSimpleName(), (Class)apiTypeClass);
                }
                return watchBaseOperation.watch(params.getResourceVersion(), resourceWatcher);
            }
        };
    }

    public synchronized <T> SharedIndexInformer<T> getExistingSharedIndexInformer(Class<T> apiTypeClass) {
        return this.informers.get(apiTypeClass);
    }

    public synchronized void startAllRegisteredInformers() {
        if (this.informers == null || this.informers.isEmpty()) {
            return;
        }
        this.informers.forEach((informerType, informer) -> this.startedInformers.computeIfAbsent((Type)informerType, key -> this.informerExecutor.submit(informer::run)));
    }

    public synchronized void stopAllRegisteredInformers() {
        this.stopAllRegisteredInformers(true);
    }

    public synchronized void stopAllRegisteredInformers(boolean shutDownThreadPool) {
        if (this.informers == null || this.informers.isEmpty()) {
            return;
        }
        this.informers.forEach((informerType, informer) -> {
            if (this.startedInformers.remove(informerType) != null) {
                informer.stop();
            }
        });
        if (shutDownThreadPool) {
            this.informerExecutor.shutdown();
        }
    }

    public void addSharedInformerEventListener(SharedInformerEventListener event) {
        this.eventListeners.add(event);
    }
}

