/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.CustomResourceOperationContext;
import io.fabric8.kubernetes.internal.KubernetesDeserializer;
import okhttp3.OkHttpClient;

public class CustomResourceOperationsImpl<T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>>
extends HasMetadataOperation<T, L, D, Resource<T, D>>
implements MixedOperation<T, L, D, Resource<T, D>> {
    private final boolean resourceNamespaced;

    public CustomResourceOperationsImpl(OkHttpClient client, Config config) {
        this(new CustomResourceOperationContext().withOkhttpClient(client).withConfig(config));
    }

    public CustomResourceOperationsImpl(CustomResourceOperationContext context) {
        super(context.withApiGroupName(CustomResourceOperationsImpl.apiGroup((CustomResourceDefinition)context.getCrd())).withApiGroupVersion(CustomResourceOperationsImpl.apiVersion((CustomResourceDefinition)context.getCrd())).withPlural(CustomResourceOperationsImpl.resourceT((CustomResourceDefinition)context.getCrd())));
        this.type = context.getType();
        this.listType = context.getListType();
        this.doneableType = context.getDoneableType();
        this.resourceNamespaced = CustomResourceOperationsImpl.resourceNamespaced((CustomResourceDefinition)context.getCrd());
        this.apiVersion = this.getAPIGroup() + "/" + this.getAPIVersion();
        CustomResourceDefinition crd = (CustomResourceDefinition)context.getCrd();
        KubernetesDeserializer.registerCustomKind((String)crd.getApiVersion(), (String)crd.getKind(), (Class)this.type);
        if (KubernetesResource.class.isAssignableFrom(this.listType)) {
            KubernetesDeserializer.registerCustomKind((String)this.listType.getSimpleName(), (Class)this.listType);
        }
    }

    public CustomResourceOperationsImpl newInstance(OperationContext context) {
        return new CustomResourceOperationsImpl<T, L, D>((CustomResourceOperationContext)context);
    }

    protected static String apiGroup(CustomResourceDefinition crd) {
        return crd.getSpec().getGroup();
    }

    protected static String apiVersion(CustomResourceDefinition crd) {
        return crd.getSpec().getVersion();
    }

    protected static String resourceT(CustomResourceDefinition crd) {
        return crd.getSpec().getNames().getPlural();
    }

    protected static String name(CustomResourceDefinition crd) {
        return crd.getMetadata().getName();
    }

    protected static boolean resourceNamespaced(CustomResourceDefinition crd) {
        return "Namespaced".equals(crd.getSpec().getScope());
    }

    @Override
    public boolean isResourceNamespaced() {
        return this.resourceNamespaced;
    }
}

