/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.ImageImportSpec;
import io.fabric8.openshift.api.model.ImageImportSpecBuilder;
import io.fabric8.openshift.api.model.ImageImportSpecFluentImpl;
import io.fabric8.openshift.api.model.ImageStreamImportSpec;
import io.fabric8.openshift.api.model.ImageStreamImportSpecFluent;
import io.fabric8.openshift.api.model.RepositoryImportSpec;
import io.fabric8.openshift.api.model.RepositoryImportSpecBuilder;
import io.fabric8.openshift.api.model.RepositoryImportSpecFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ImageStreamImportSpecFluentImpl<A extends ImageStreamImportSpecFluent<A>>
extends BaseFluent<A>
implements ImageStreamImportSpecFluent<A> {
    private List<ImageImportSpecBuilder> images = new ArrayList<ImageImportSpecBuilder>();
    private Boolean _import;
    private RepositoryImportSpecBuilder repository;

    public ImageStreamImportSpecFluentImpl() {
    }

    public ImageStreamImportSpecFluentImpl(ImageStreamImportSpec instance) {
        this.withImages(instance.getImages());
        this.withImport(instance.getImport());
        this.withRepository(instance.getRepository());
    }

    @Override
    public A addToImages(int index, ImageImportSpec item) {
        if (this.images == null) {
            this.images = new ArrayList<ImageImportSpecBuilder>();
        }
        ImageImportSpecBuilder builder = new ImageImportSpecBuilder(item);
        this._visitables.get((Object)"images").add(index >= 0 ? index : this._visitables.get((Object)"images").size(), builder);
        this.images.add(index >= 0 ? index : this.images.size(), builder);
        return (A)this;
    }

    @Override
    public A setToImages(int index, ImageImportSpec item) {
        if (this.images == null) {
            this.images = new ArrayList<ImageImportSpecBuilder>();
        }
        ImageImportSpecBuilder builder = new ImageImportSpecBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"images").size()) {
            this._visitables.get((Object)"images").add(builder);
        } else {
            this._visitables.get((Object)"images").set(index, builder);
        }
        if (index < 0 || index >= this.images.size()) {
            this.images.add(builder);
        } else {
            this.images.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToImages(ImageImportSpec ... items) {
        if (this.images == null) {
            this.images = new ArrayList<ImageImportSpecBuilder>();
        }
        for (ImageImportSpec item : items) {
            ImageImportSpecBuilder builder = new ImageImportSpecBuilder(item);
            this._visitables.get((Object)"images").add(builder);
            this.images.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToImages(Collection<ImageImportSpec> items) {
        if (this.images == null) {
            this.images = new ArrayList<ImageImportSpecBuilder>();
        }
        for (ImageImportSpec item : items) {
            ImageImportSpecBuilder builder = new ImageImportSpecBuilder(item);
            this._visitables.get((Object)"images").add(builder);
            this.images.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromImages(ImageImportSpec ... items) {
        for (ImageImportSpec item : items) {
            ImageImportSpecBuilder builder = new ImageImportSpecBuilder(item);
            this._visitables.get((Object)"images").remove(builder);
            if (this.images == null) continue;
            this.images.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImages(Collection<ImageImportSpec> items) {
        for (ImageImportSpec item : items) {
            ImageImportSpecBuilder builder = new ImageImportSpecBuilder(item);
            this._visitables.get((Object)"images").remove(builder);
            if (this.images == null) continue;
            this.images.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromImages(Predicate<ImageImportSpecBuilder> predicate) {
        if (this.images == null) {
            return (A)this;
        }
        Iterator<ImageImportSpecBuilder> each = this.images.iterator();
        List visitables = this._visitables.get((Object)"images");
        while (each.hasNext()) {
            ImageImportSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ImageImportSpec> getImages() {
        return ImageStreamImportSpecFluentImpl.build(this.images);
    }

    @Override
    public List<ImageImportSpec> buildImages() {
        return ImageStreamImportSpecFluentImpl.build(this.images);
    }

    @Override
    public ImageImportSpec buildImage(int index) {
        return this.images.get(index).build();
    }

    @Override
    public ImageImportSpec buildFirstImage() {
        return this.images.get(0).build();
    }

    @Override
    public ImageImportSpec buildLastImage() {
        return this.images.get(this.images.size() - 1).build();
    }

    @Override
    public ImageImportSpec buildMatchingImage(Predicate<ImageImportSpecBuilder> predicate) {
        for (ImageImportSpecBuilder item : this.images) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingImage(Predicate<ImageImportSpecBuilder> predicate) {
        for (ImageImportSpecBuilder item : this.images) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withImages(List<ImageImportSpec> images) {
        if (this.images != null) {
            this._visitables.get((Object)"images").removeAll(this.images);
        }
        if (images != null) {
            this.images = new ArrayList<ImageImportSpecBuilder>();
            for (ImageImportSpec item : images) {
                this.addToImages(item);
            }
        } else {
            this.images = null;
        }
        return (A)this;
    }

    @Override
    public A withImages(ImageImportSpec ... images) {
        if (this.images != null) {
            this.images.clear();
        }
        if (images != null) {
            for (ImageImportSpec item : images) {
                this.addToImages(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasImages() {
        return this.images != null && !this.images.isEmpty();
    }

    @Override
    public ImageStreamImportSpecFluent.ImagesNested<A> addNewImage() {
        return new ImagesNestedImpl();
    }

    @Override
    public ImageStreamImportSpecFluent.ImagesNested<A> addNewImageLike(ImageImportSpec item) {
        return new ImagesNestedImpl(-1, item);
    }

    @Override
    public ImageStreamImportSpecFluent.ImagesNested<A> setNewImageLike(int index, ImageImportSpec item) {
        return new ImagesNestedImpl(index, item);
    }

    @Override
    public ImageStreamImportSpecFluent.ImagesNested<A> editImage(int index) {
        if (this.images.size() <= index) {
            throw new RuntimeException("Can't edit images. Index exceeds size.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    @Override
    public ImageStreamImportSpecFluent.ImagesNested<A> editFirstImage() {
        if (this.images.size() == 0) {
            throw new RuntimeException("Can't edit first images. The list is empty.");
        }
        return this.setNewImageLike(0, this.buildImage(0));
    }

    @Override
    public ImageStreamImportSpecFluent.ImagesNested<A> editLastImage() {
        int index = this.images.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last images. The list is empty.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    @Override
    public ImageStreamImportSpecFluent.ImagesNested<A> editMatchingImage(Predicate<ImageImportSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.images.size(); ++i) {
            if (!predicate.test(this.images.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching images. No match found.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    @Override
    public Boolean getImport() {
        return this._import;
    }

    @Override
    public A withImport(Boolean _import) {
        this._import = _import;
        return (A)this;
    }

    @Override
    public Boolean hasImport() {
        return this._import != null;
    }

    @Override
    public A withNewImport(String arg1) {
        return this.withImport(new Boolean(arg1));
    }

    @Override
    public A withNewImport(boolean arg1) {
        return this.withImport(new Boolean(arg1));
    }

    @Override
    @Deprecated
    public RepositoryImportSpec getRepository() {
        return this.repository != null ? this.repository.build() : null;
    }

    @Override
    public RepositoryImportSpec buildRepository() {
        return this.repository != null ? this.repository.build() : null;
    }

    @Override
    public A withRepository(RepositoryImportSpec repository) {
        this._visitables.get((Object)"repository").remove(this.repository);
        if (repository != null) {
            this.repository = new RepositoryImportSpecBuilder(repository);
            this._visitables.get((Object)"repository").add(this.repository);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRepository() {
        return this.repository != null;
    }

    @Override
    public ImageStreamImportSpecFluent.RepositoryNested<A> withNewRepository() {
        return new RepositoryNestedImpl();
    }

    @Override
    public ImageStreamImportSpecFluent.RepositoryNested<A> withNewRepositoryLike(RepositoryImportSpec item) {
        return new RepositoryNestedImpl(item);
    }

    @Override
    public ImageStreamImportSpecFluent.RepositoryNested<A> editRepository() {
        return this.withNewRepositoryLike(this.getRepository());
    }

    @Override
    public ImageStreamImportSpecFluent.RepositoryNested<A> editOrNewRepository() {
        return this.withNewRepositoryLike(this.getRepository() != null ? this.getRepository() : new RepositoryImportSpecBuilder().build());
    }

    @Override
    public ImageStreamImportSpecFluent.RepositoryNested<A> editOrNewRepositoryLike(RepositoryImportSpec item) {
        return this.withNewRepositoryLike(this.getRepository() != null ? this.getRepository() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageStreamImportSpecFluentImpl that = (ImageStreamImportSpecFluentImpl)o;
        if (this.images != null ? !this.images.equals(that.images) : that.images != null) {
            return false;
        }
        if (this._import != null ? !this._import.equals(that._import) : that._import != null) {
            return false;
        }
        return !(this.repository != null ? !this.repository.equals(that.repository) : that.repository != null);
    }

    public int hashCode() {
        return Objects.hash(this.images, this._import, this.repository, super.hashCode());
    }

    public class RepositoryNestedImpl<N>
    extends RepositoryImportSpecFluentImpl<ImageStreamImportSpecFluent.RepositoryNested<N>>
    implements ImageStreamImportSpecFluent.RepositoryNested<N>,
    Nested<N> {
        private final RepositoryImportSpecBuilder builder;

        RepositoryNestedImpl(RepositoryImportSpec item) {
            this.builder = new RepositoryImportSpecBuilder(this, item);
        }

        RepositoryNestedImpl() {
            this.builder = new RepositoryImportSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageStreamImportSpecFluentImpl.this.withRepository(this.builder.build());
        }

        @Override
        public N endRepository() {
            return this.and();
        }
    }

    public class ImagesNestedImpl<N>
    extends ImageImportSpecFluentImpl<ImageStreamImportSpecFluent.ImagesNested<N>>
    implements ImageStreamImportSpecFluent.ImagesNested<N>,
    Nested<N> {
        private final ImageImportSpecBuilder builder;
        private final int index;

        ImagesNestedImpl(int index, ImageImportSpec item) {
            this.index = index;
            this.builder = new ImageImportSpecBuilder(this, item);
        }

        ImagesNestedImpl() {
            this.index = -1;
            this.builder = new ImageImportSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageStreamImportSpecFluentImpl.this.setToImages(this.index, this.builder.build());
        }

        @Override
        public N endImage() {
            return this.and();
        }
    }
}

