/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.DownwardAPIVolumeFile;
import io.fabric8.kubernetes.api.model.DownwardAPIVolumeFileBuilder;
import io.fabric8.kubernetes.api.model.DownwardAPIVolumeFileFluentImpl;
import io.fabric8.kubernetes.api.model.DownwardAPIVolumeSource;
import io.fabric8.kubernetes.api.model.DownwardAPIVolumeSourceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class DownwardAPIVolumeSourceFluentImpl<A extends DownwardAPIVolumeSourceFluent<A>>
extends BaseFluent<A>
implements DownwardAPIVolumeSourceFluent<A> {
    private Integer defaultMode;
    private List<DownwardAPIVolumeFileBuilder> items = new ArrayList<DownwardAPIVolumeFileBuilder>();

    public DownwardAPIVolumeSourceFluentImpl() {
    }

    public DownwardAPIVolumeSourceFluentImpl(DownwardAPIVolumeSource instance) {
        this.withDefaultMode(instance.getDefaultMode());
        this.withItems(instance.getItems());
    }

    @Override
    public Integer getDefaultMode() {
        return this.defaultMode;
    }

    @Override
    public A withDefaultMode(Integer defaultMode) {
        this.defaultMode = defaultMode;
        return (A)this;
    }

    @Override
    public Boolean hasDefaultMode() {
        return this.defaultMode != null;
    }

    @Override
    public A withNewDefaultMode(String arg1) {
        return this.withDefaultMode(new Integer(arg1));
    }

    @Override
    public A withNewDefaultMode(int arg1) {
        return this.withDefaultMode(new Integer(arg1));
    }

    @Override
    public A addToItems(int index, DownwardAPIVolumeFile item) {
        if (this.items == null) {
            this.items = new ArrayList<DownwardAPIVolumeFileBuilder>();
        }
        DownwardAPIVolumeFileBuilder builder = new DownwardAPIVolumeFileBuilder(item);
        this._visitables.get("items").add(index >= 0 ? index : this._visitables.get("items").size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, DownwardAPIVolumeFile item) {
        if (this.items == null) {
            this.items = new ArrayList<DownwardAPIVolumeFileBuilder>();
        }
        DownwardAPIVolumeFileBuilder builder = new DownwardAPIVolumeFileBuilder(item);
        if (index < 0 || index >= this._visitables.get("items").size()) {
            this._visitables.get("items").add(builder);
        } else {
            this._visitables.get("items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(DownwardAPIVolumeFile ... items) {
        if (this.items == null) {
            this.items = new ArrayList<DownwardAPIVolumeFileBuilder>();
        }
        for (DownwardAPIVolumeFile item : items) {
            DownwardAPIVolumeFileBuilder builder = new DownwardAPIVolumeFileBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<DownwardAPIVolumeFile> items) {
        if (this.items == null) {
            this.items = new ArrayList<DownwardAPIVolumeFileBuilder>();
        }
        for (DownwardAPIVolumeFile item : items) {
            DownwardAPIVolumeFileBuilder builder = new DownwardAPIVolumeFileBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(DownwardAPIVolumeFile ... items) {
        for (DownwardAPIVolumeFile item : items) {
            DownwardAPIVolumeFileBuilder builder = new DownwardAPIVolumeFileBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<DownwardAPIVolumeFile> items) {
        for (DownwardAPIVolumeFile item : items) {
            DownwardAPIVolumeFileBuilder builder = new DownwardAPIVolumeFileBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<DownwardAPIVolumeFileBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<DownwardAPIVolumeFileBuilder> each = this.items.iterator();
        Object visitables = this._visitables.get("items");
        while (each.hasNext()) {
            DownwardAPIVolumeFileBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<DownwardAPIVolumeFile> getItems() {
        return DownwardAPIVolumeSourceFluentImpl.build(this.items);
    }

    @Override
    public List<DownwardAPIVolumeFile> buildItems() {
        return DownwardAPIVolumeSourceFluentImpl.build(this.items);
    }

    @Override
    public DownwardAPIVolumeFile buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public DownwardAPIVolumeFile buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public DownwardAPIVolumeFile buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public DownwardAPIVolumeFile buildMatchingItem(Predicate<DownwardAPIVolumeFileBuilder> predicate) {
        for (DownwardAPIVolumeFileBuilder item : this.items) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<DownwardAPIVolumeFileBuilder> predicate) {
        for (DownwardAPIVolumeFileBuilder item : this.items) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<DownwardAPIVolumeFile> items) {
        if (this.items != null) {
            this._visitables.get("items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<DownwardAPIVolumeFileBuilder>();
            for (DownwardAPIVolumeFile item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(DownwardAPIVolumeFile ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (DownwardAPIVolumeFile item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public DownwardAPIVolumeSourceFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public DownwardAPIVolumeSourceFluent.ItemsNested<A> addNewItemLike(DownwardAPIVolumeFile item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public DownwardAPIVolumeSourceFluent.ItemsNested<A> setNewItemLike(int index, DownwardAPIVolumeFile item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public DownwardAPIVolumeSourceFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public DownwardAPIVolumeSourceFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public DownwardAPIVolumeSourceFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public DownwardAPIVolumeSourceFluent.ItemsNested<A> editMatchingItem(Predicate<DownwardAPIVolumeFileBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.apply(this.items.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownwardAPIVolumeSourceFluentImpl that = (DownwardAPIVolumeSourceFluentImpl)o;
        if (this.defaultMode != null ? !this.defaultMode.equals(that.defaultMode) : that.defaultMode != null) {
            return false;
        }
        return !(this.items != null ? !this.items.equals(that.items) : that.items != null);
    }

    public class ItemsNestedImpl<N>
    extends DownwardAPIVolumeFileFluentImpl<DownwardAPIVolumeSourceFluent.ItemsNested<N>>
    implements DownwardAPIVolumeSourceFluent.ItemsNested<N>,
    Nested<N> {
        private final DownwardAPIVolumeFileBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, DownwardAPIVolumeFile item) {
            this.index = index;
            this.builder = new DownwardAPIVolumeFileBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new DownwardAPIVolumeFileBuilder(this);
        }

        @Override
        public N and() {
            return (N)DownwardAPIVolumeSourceFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

