/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.cloud;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.cloud.ServiceFilter;

public class CombinedServiceFilter
implements ServiceFilter {
    private final List<ServiceFilter> delegates;
    private final int delegatesSize;

    public CombinedServiceFilter(List<ServiceFilter> delegates) {
        this.delegates = Collections.unmodifiableList(new ArrayList<ServiceFilter>(delegates));
        this.delegatesSize = this.delegates.size();
    }

    public List<ServiceFilter> getDelegates() {
        return this.delegates;
    }

    public List<ServiceDefinition> apply(Exchange exchange, List<ServiceDefinition> services) {
        for (int i = 0; i < this.delegatesSize; ++i) {
            services = this.delegates.get(i).apply(exchange, services);
        }
        return services;
    }

    public static CombinedServiceFilter wrap(ServiceFilter ... delegates) {
        return new CombinedServiceFilter(Arrays.asList(delegates));
    }
}

