/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.customresources;

import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.internal.RawCustomResourceOperationsImpl;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesConfiguration;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesCustomResourcesConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesCustomResourcesConsumer.class);
    private final Processor processor;
    private ExecutorService executor;
    private CustomResourcesConsumerTask customResourcesWatcher;

    public KubernetesCustomResourcesConsumer(AbstractKubernetesEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.processor = processor;
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().createExecutor();
        this.customResourcesWatcher = new CustomResourcesConsumerTask();
        this.executor.submit(this.customResourcesWatcher);
    }

    protected void doStop() throws Exception {
        LOG.debug("Stopping Kubernetes Custom Resources Consumer");
        if (this.executor != null) {
            KubernetesHelper.close(this.customResourcesWatcher, this.customResourcesWatcher::getWatch);
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
        super.doStop();
    }

    private CustomResourceDefinitionContext getCRDContext(KubernetesConfiguration config) {
        if (ObjectHelper.isEmpty((Object)config.getCrdName()) || ObjectHelper.isEmpty((Object)config.getCrdGroup()) || ObjectHelper.isEmpty((Object)config.getCrdScope()) || ObjectHelper.isEmpty((Object)config.getCrdVersion()) || ObjectHelper.isEmpty((Object)config.getCrdPlural())) {
            LOG.error("one of more of the custom resource definition argument(s) are missing.");
            throw new IllegalArgumentException("one of more of the custom resource definition argument(s) are missing.");
        }
        CustomResourceDefinitionContext cRDContext = new CustomResourceDefinitionContext.Builder().withName(config.getCrdName()).withGroup(config.getCrdGroup()).withScope(config.getCrdScope()).withVersion(config.getCrdVersion()).withPlural(config.getCrdPlural()).build();
        return cRDContext;
    }

    class CustomResourcesConsumerTask
    implements Runnable {
        private Watch watch;

        CustomResourcesConsumerTask() {
        }

        @Override
        public void run() {
            RawCustomResourceOperationsImpl operations = KubernetesCustomResourcesConsumer.this.getEndpoint().getKubernetesClient().customResource(KubernetesCustomResourcesConsumer.this.getCRDContext(KubernetesCustomResourcesConsumer.this.getEndpoint().getKubernetesConfiguration()));
            if (ObjectHelper.isNotEmpty((Object)KubernetesCustomResourcesConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespace())) {
                LOG.error("namespace is not specified.");
            }
            String namespace = KubernetesCustomResourcesConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespace();
            try {
                operations.watch(namespace, (Watcher)new Watcher<String>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void eventReceived(Watcher.Action action, String resource) {
                        Exchange exchange = KubernetesCustomResourcesConsumer.this.createExchange(false);
                        exchange.getIn().setBody((Object)resource);
                        exchange.getIn().setHeader("CamelKubernetesCRDEventAction", (Object)action);
                        exchange.getIn().setHeader("CamelKubernetesCRDEventTimestamp", (Object)System.currentTimeMillis());
                        try {
                            KubernetesCustomResourcesConsumer.this.processor.process(exchange);
                        }
                        catch (Exception e) {
                            KubernetesCustomResourcesConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                        }
                        finally {
                            KubernetesCustomResourcesConsumer.this.releaseExchange(exchange, false);
                        }
                    }

                    public void onClose(WatcherException cause) {
                        if (cause != null) {
                            LOG.error(cause.getMessage(), (Throwable)cause);
                        }
                    }
                });
            }
            catch (Exception e) {
                LOG.error("Exception in handling githubsource instance change", (Throwable)e);
            }
        }

        public Watch getWatch() {
            return this.watch;
        }

        public void setWatch(Watch watch) {
            this.watch = watch;
        }
    }
}

