/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import io.fabric8.openshift.api.model.operator.v1.Authentication;
import io.fabric8.openshift.api.model.operator.v1.AuthenticationBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.AuthenticationOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class AuthenticationHandler
implements ResourceHandler<Authentication, AuthenticationBuilder> {
    public String getKind() {
        return Authentication.class.getSimpleName();
    }

    public String getApiVersion() {
        return "operator.openshift.io/v1";
    }

    public Authentication create(OkHttpClient client, Config config, String namespace, Authentication item, boolean dryRun) {
        return (Authentication)((WritableOperation)new AuthenticationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).dryRun(dryRun)).create((Object[])new Authentication[0]);
    }

    public Authentication replace(OkHttpClient client, Config config, String namespace, Authentication item, boolean dryRun) {
        return (Authentication)((WritableOperation)((Resource)new AuthenticationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace((Object)item);
    }

    public Authentication reload(OkHttpClient client, Config config, String namespace, Authentication item) {
        return (Authentication)((Gettable)((Resource)new AuthenticationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public AuthenticationBuilder edit(Authentication item) {
        return new AuthenticationBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Authentication item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new AuthenticationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Authentication item, Watcher<Authentication> watcher) {
        return ((Resource)new AuthenticationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Authentication item, String resourceVersion, Watcher<Authentication> watcher) {
        return ((Resource)new AuthenticationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Authentication item, ListOptions options, Watcher<Authentication> watcher) {
        return ((Resource)new AuthenticationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public Authentication waitUntilReady(OkHttpClient client, Config config, String namespace, Authentication item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Authentication)((Resource)new AuthenticationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public Authentication waitUntilCondition(OkHttpClient client, Config config, String namespace, Authentication item, Predicate<Authentication> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Authentication)((Resource)new AuthenticationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

