/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.openshift.api.model.ImageImportStatus;
import io.fabric8.openshift.api.model.ImageImportStatusBuilder;
import io.fabric8.openshift.api.model.ImageImportStatusFluentImpl;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluentImpl;
import io.fabric8.openshift.api.model.ImageStreamImportStatus;
import io.fabric8.openshift.api.model.ImageStreamImportStatusFluent;
import io.fabric8.openshift.api.model.RepositoryImportStatus;
import io.fabric8.openshift.api.model.RepositoryImportStatusBuilder;
import io.fabric8.openshift.api.model.RepositoryImportStatusFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class ImageStreamImportStatusFluentImpl<A extends ImageStreamImportStatusFluent<A>>
extends BaseFluent<A>
implements ImageStreamImportStatusFluent<A> {
    private List<ImageImportStatusBuilder> images = new ArrayList<ImageImportStatusBuilder>();
    private ImageStreamBuilder _import;
    private RepositoryImportStatusBuilder repository;

    public ImageStreamImportStatusFluentImpl() {
    }

    public ImageStreamImportStatusFluentImpl(ImageStreamImportStatus instance) {
        this.withImages(instance.getImages());
        this.withImport(instance.getImport());
        this.withRepository(instance.getRepository());
    }

    @Override
    public A addToImages(int index, ImageImportStatus item) {
        if (this.images == null) {
            this.images = new ArrayList<ImageImportStatusBuilder>();
        }
        ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);
        this._visitables.get((Object)"images").add(index >= 0 ? index : this._visitables.get((Object)"images").size(), builder);
        this.images.add(index >= 0 ? index : this.images.size(), builder);
        return (A)this;
    }

    @Override
    public A setToImages(int index, ImageImportStatus item) {
        if (this.images == null) {
            this.images = new ArrayList<ImageImportStatusBuilder>();
        }
        ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"images").size()) {
            this._visitables.get((Object)"images").add(builder);
        } else {
            this._visitables.get((Object)"images").set(index, builder);
        }
        if (index < 0 || index >= this.images.size()) {
            this.images.add(builder);
        } else {
            this.images.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToImages(ImageImportStatus ... items) {
        if (this.images == null) {
            this.images = new ArrayList<ImageImportStatusBuilder>();
        }
        for (ImageImportStatus item : items) {
            ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);
            this._visitables.get((Object)"images").add(builder);
            this.images.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToImages(Collection<ImageImportStatus> items) {
        if (this.images == null) {
            this.images = new ArrayList<ImageImportStatusBuilder>();
        }
        for (ImageImportStatus item : items) {
            ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);
            this._visitables.get((Object)"images").add(builder);
            this.images.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromImages(ImageImportStatus ... items) {
        for (ImageImportStatus item : items) {
            ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);
            this._visitables.get((Object)"images").remove(builder);
            if (this.images == null) continue;
            this.images.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImages(Collection<ImageImportStatus> items) {
        for (ImageImportStatus item : items) {
            ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);
            this._visitables.get((Object)"images").remove(builder);
            if (this.images == null) continue;
            this.images.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromImages(Predicate<ImageImportStatusBuilder> predicate) {
        if (this.images == null) {
            return (A)this;
        }
        Iterator<ImageImportStatusBuilder> each = this.images.iterator();
        List visitables = this._visitables.get((Object)"images");
        while (each.hasNext()) {
            ImageImportStatusBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ImageImportStatus> getImages() {
        return ImageStreamImportStatusFluentImpl.build(this.images);
    }

    @Override
    public List<ImageImportStatus> buildImages() {
        return ImageStreamImportStatusFluentImpl.build(this.images);
    }

    @Override
    public ImageImportStatus buildImage(int index) {
        return this.images.get(index).build();
    }

    @Override
    public ImageImportStatus buildFirstImage() {
        return this.images.get(0).build();
    }

    @Override
    public ImageImportStatus buildLastImage() {
        return this.images.get(this.images.size() - 1).build();
    }

    @Override
    public ImageImportStatus buildMatchingImage(Predicate<ImageImportStatusBuilder> predicate) {
        for (ImageImportStatusBuilder item : this.images) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingImage(Predicate<ImageImportStatusBuilder> predicate) {
        for (ImageImportStatusBuilder item : this.images) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withImages(List<ImageImportStatus> images) {
        if (this.images != null) {
            this._visitables.get((Object)"images").removeAll(this.images);
        }
        if (images != null) {
            this.images = new ArrayList<ImageImportStatusBuilder>();
            for (ImageImportStatus item : images) {
                this.addToImages(item);
            }
        } else {
            this.images = null;
        }
        return (A)this;
    }

    @Override
    public A withImages(ImageImportStatus ... images) {
        if (this.images != null) {
            this.images.clear();
        }
        if (images != null) {
            for (ImageImportStatus item : images) {
                this.addToImages(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasImages() {
        return this.images != null && !this.images.isEmpty();
    }

    @Override
    public ImageStreamImportStatusFluent.ImagesNested<A> addNewImage() {
        return new ImagesNestedImpl();
    }

    @Override
    public ImageStreamImportStatusFluent.ImagesNested<A> addNewImageLike(ImageImportStatus item) {
        return new ImagesNestedImpl(-1, item);
    }

    @Override
    public ImageStreamImportStatusFluent.ImagesNested<A> setNewImageLike(int index, ImageImportStatus item) {
        return new ImagesNestedImpl(index, item);
    }

    @Override
    public ImageStreamImportStatusFluent.ImagesNested<A> editImage(int index) {
        if (this.images.size() <= index) {
            throw new RuntimeException("Can't edit images. Index exceeds size.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    @Override
    public ImageStreamImportStatusFluent.ImagesNested<A> editFirstImage() {
        if (this.images.size() == 0) {
            throw new RuntimeException("Can't edit first images. The list is empty.");
        }
        return this.setNewImageLike(0, this.buildImage(0));
    }

    @Override
    public ImageStreamImportStatusFluent.ImagesNested<A> editLastImage() {
        int index = this.images.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last images. The list is empty.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    @Override
    public ImageStreamImportStatusFluent.ImagesNested<A> editMatchingImage(Predicate<ImageImportStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.images.size(); ++i) {
            if (!predicate.apply((Object)this.images.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching images. No match found.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    @Override
    @Deprecated
    public ImageStream getImport() {
        return this._import != null ? this._import.build() : null;
    }

    @Override
    public ImageStream buildImport() {
        return this._import != null ? this._import.build() : null;
    }

    @Override
    public A withImport(ImageStream _import) {
        this._visitables.get((Object)"_import").remove(this._import);
        if (_import != null) {
            this._import = new ImageStreamBuilder(_import);
            this._visitables.get((Object)"_import").add(this._import);
        }
        return (A)this;
    }

    @Override
    public Boolean hasImport() {
        return this._import != null;
    }

    @Override
    public ImageStreamImportStatusFluent.ImportNested<A> withNewImport() {
        return new ImportNestedImpl();
    }

    @Override
    public ImageStreamImportStatusFluent.ImportNested<A> withNewImportLike(ImageStream item) {
        return new ImportNestedImpl(item);
    }

    @Override
    public ImageStreamImportStatusFluent.ImportNested<A> editImport() {
        return this.withNewImportLike(this.getImport());
    }

    @Override
    public ImageStreamImportStatusFluent.ImportNested<A> editOrNewImport() {
        return this.withNewImportLike(this.getImport() != null ? this.getImport() : new ImageStreamBuilder().build());
    }

    @Override
    public ImageStreamImportStatusFluent.ImportNested<A> editOrNewImportLike(ImageStream item) {
        return this.withNewImportLike(this.getImport() != null ? this.getImport() : item);
    }

    @Override
    @Deprecated
    public RepositoryImportStatus getRepository() {
        return this.repository != null ? this.repository.build() : null;
    }

    @Override
    public RepositoryImportStatus buildRepository() {
        return this.repository != null ? this.repository.build() : null;
    }

    @Override
    public A withRepository(RepositoryImportStatus repository) {
        this._visitables.get((Object)"repository").remove(this.repository);
        if (repository != null) {
            this.repository = new RepositoryImportStatusBuilder(repository);
            this._visitables.get((Object)"repository").add(this.repository);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRepository() {
        return this.repository != null;
    }

    @Override
    public ImageStreamImportStatusFluent.RepositoryNested<A> withNewRepository() {
        return new RepositoryNestedImpl();
    }

    @Override
    public ImageStreamImportStatusFluent.RepositoryNested<A> withNewRepositoryLike(RepositoryImportStatus item) {
        return new RepositoryNestedImpl(item);
    }

    @Override
    public ImageStreamImportStatusFluent.RepositoryNested<A> editRepository() {
        return this.withNewRepositoryLike(this.getRepository());
    }

    @Override
    public ImageStreamImportStatusFluent.RepositoryNested<A> editOrNewRepository() {
        return this.withNewRepositoryLike(this.getRepository() != null ? this.getRepository() : new RepositoryImportStatusBuilder().build());
    }

    @Override
    public ImageStreamImportStatusFluent.RepositoryNested<A> editOrNewRepositoryLike(RepositoryImportStatus item) {
        return this.withNewRepositoryLike(this.getRepository() != null ? this.getRepository() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageStreamImportStatusFluentImpl that = (ImageStreamImportStatusFluentImpl)o;
        if (this.images != null ? !this.images.equals(that.images) : that.images != null) {
            return false;
        }
        if (this._import != null ? !this._import.equals(that._import) : that._import != null) {
            return false;
        }
        return !(this.repository != null ? !this.repository.equals(that.repository) : that.repository != null);
    }

    public int hashCode() {
        return Objects.hash(this.images, this._import, this.repository, super.hashCode());
    }

    public class RepositoryNestedImpl<N>
    extends RepositoryImportStatusFluentImpl<ImageStreamImportStatusFluent.RepositoryNested<N>>
    implements ImageStreamImportStatusFluent.RepositoryNested<N>,
    Nested<N> {
        private final RepositoryImportStatusBuilder builder;

        RepositoryNestedImpl(RepositoryImportStatus item) {
            this.builder = new RepositoryImportStatusBuilder(this, item);
        }

        RepositoryNestedImpl() {
            this.builder = new RepositoryImportStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageStreamImportStatusFluentImpl.this.withRepository(this.builder.build());
        }

        @Override
        public N endRepository() {
            return this.and();
        }
    }

    public class ImportNestedImpl<N>
    extends ImageStreamFluentImpl<ImageStreamImportStatusFluent.ImportNested<N>>
    implements ImageStreamImportStatusFluent.ImportNested<N>,
    Nested<N> {
        private final ImageStreamBuilder builder;

        ImportNestedImpl(ImageStream item) {
            this.builder = new ImageStreamBuilder(this, item);
        }

        ImportNestedImpl() {
            this.builder = new ImageStreamBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageStreamImportStatusFluentImpl.this.withImport(this.builder.build());
        }

        @Override
        public N endImport() {
            return this.and();
        }
    }

    public class ImagesNestedImpl<N>
    extends ImageImportStatusFluentImpl<ImageStreamImportStatusFluent.ImagesNested<N>>
    implements ImageStreamImportStatusFluent.ImagesNested<N>,
    Nested<N> {
        private final ImageImportStatusBuilder builder;
        private final int index;

        ImagesNestedImpl(int index, ImageImportStatus item) {
            this.index = index;
            this.builder = new ImageImportStatusBuilder(this, item);
        }

        ImagesNestedImpl() {
            this.index = -1;
            this.builder = new ImageImportStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageStreamImportStatusFluentImpl.this.setToImages(this.index, this.builder.build());
        }

        @Override
        public N endImage() {
            return this.and();
        }
    }
}

