/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jackson.avro.transform;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.dataformat.avro.AvroSchema;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.jackson.SchemaHelper;
import org.apache.camel.component.jackson.avro.transform.Avro;
import org.apache.camel.component.jackson.transform.Json;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.MimeType;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="avro-binary")
public class AvroBinaryDataTypeTransformer
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) {
        AvroSchema schema = (AvroSchema)message.getExchange().getProperty("X-Content-Schema", AvroSchema.class);
        if (schema == null) {
            throw new CamelExecutionException("Missing proper avro schema for data type processing", message.getExchange());
        }
        try {
            byte[] marshalled;
            String contentClass = SchemaHelper.resolveContentClass((Exchange)message.getExchange(), null);
            if (contentClass != null) {
                Class contentType = message.getExchange().getContext().getClassResolver().resolveMandatoryClass(contentClass);
                marshalled = Avro.mapper().writer().forType(contentType).with((FormatSchema)schema).writeValueAsBytes(message.getBody());
            } else {
                marshalled = Avro.mapper().writer().forType(JsonNode.class).with((FormatSchema)schema).writeValueAsBytes((Object)this.getBodyAsJsonNode(message, schema));
            }
            message.setBody((Object)marshalled);
            message.setHeader("Content-Type", (Object)MimeType.AVRO_BINARY.type());
            message.setHeader("X-Content-Schema", (Object)schema.getAvroSchema().getFullName());
        }
        catch (IOException | ClassNotFoundException | InvalidPayloadException e) {
            throw new CamelExecutionException("Failed to apply Avro binary data type on exchange", message.getExchange(), e);
        }
    }

    private JsonNode getBodyAsJsonNode(Message message, AvroSchema schema) throws InvalidPayloadException, IOException, ClassNotFoundException {
        String jsonString;
        if (message.getBody() instanceof JsonNode) {
            return (JsonNode)message.getBody();
        }
        Object object = message.getBody();
        if (object instanceof String && Json.isJson((String)(jsonString = (String)object))) {
            return Json.mapper().readerFor(JsonNode.class).readTree(jsonString);
        }
        return (JsonNode)Avro.mapper().reader().forType(JsonNode.class).with((FormatSchema)schema).readValue(this.getBodyAsStream(message));
    }

    private InputStream getBodyAsStream(Message message) throws InvalidPayloadException {
        InputStream bodyStream = (InputStream)message.getBody(InputStream.class);
        if (bodyStream == null) {
            bodyStream = new ByteArrayInputStream((byte[])message.getMandatoryBody(byte[].class));
        }
        return bodyStream;
    }
}

