/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kamelets.utils.format.converter.protobuf;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.dataformat.protobuf.schema.ProtobufSchema;
import com.fasterxml.jackson.dataformat.protobuf.schema.ProtobufSchemaLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.jackson.SchemaResolver;
import org.apache.camel.kamelets.utils.format.SchemaType;
import org.apache.camel.kamelets.utils.format.converter.protobuf.Protobuf;
import org.apache.camel.kamelets.utils.format.converter.utils.SchemaHelper;
import org.apache.camel.spi.Resource;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.ObjectHelper;

public class ProtobufSchemaResolver
implements SchemaResolver,
Processor {
    private final ConcurrentMap<String, ProtobufSchema> schemes = new ConcurrentHashMap<String, ProtobufSchema>();
    private ProtobufSchema schema;
    private String contentClass;

    public String getSchema() {
        if (this.schema != null) {
            return this.schema.getSource().toString();
        }
        return null;
    }

    public void setSchema(String schema) {
        if (ObjectHelper.isNotEmpty((String)schema)) {
            try {
                this.schema = ProtobufSchemaLoader.std.parse(schema);
            }
            catch (IOException e) {
                throw new RuntimeCamelException("Cannot parse protobuf schema", (Throwable)e);
            }
        } else {
            this.schema = null;
        }
    }

    public String getContentClass() {
        return this.contentClass;
    }

    public void setContentClass(String contentClass) {
        this.contentClass = ObjectHelper.isNotEmpty((String)contentClass) ? contentClass : null;
    }

    public void process(Exchange exchange) throws Exception {
        Object payload = exchange.getMessage().getBody();
        if (payload == null) {
            return;
        }
        ProtobufSchema answer = this.computeIfAbsent(exchange);
        if (answer != null) {
            exchange.setProperty("X-Content-Schema", (Object)answer);
            exchange.setProperty("X-Content-Schema-Type", (Object)SchemaType.PROTOBUF.type());
            exchange.setProperty("X-Content-Class", (Object)SchemaHelper.resolveContentClass(exchange, this.contentClass));
        }
    }

    public FormatSchema resolve(Exchange exchange) {
        ProtobufSchema answer = (ProtobufSchema)exchange.getProperty("X-Content-Schema", ProtobufSchema.class);
        if (answer == null) {
            answer = this.computeIfAbsent(exchange);
        }
        return answer;
    }

    private ProtobufSchema computeIfAbsent(Exchange exchange) {
        String contentClass;
        if (this.schema != null) {
            return this.schema;
        }
        ProtobufSchema answer = (ProtobufSchema)exchange.getProperty("X-Content-Schema", ProtobufSchema.class);
        if (answer == null && exchange.getProperties().containsKey("schema")) {
            String schemaJson = (String)exchange.getProperty("schema", String.class);
            try {
                answer = ProtobufSchemaLoader.std.parse(schemaJson);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to parse Protobuf schema", e);
            }
        }
        if (answer == null && (contentClass = SchemaHelper.resolveContentClass(exchange, this.contentClass)) != null) {
            answer = this.schemes.computeIfAbsent(contentClass, t -> {
                block11: {
                    Resource res = PluginHelper.getResourceLoader((CamelContext)exchange.getContext()).resolveResource("classpath:schemas/" + SchemaType.AVRO.type() + "/" + t + "." + SchemaType.AVRO.type());
                    try {
                        if (!res.exists()) break block11;
                        try (InputStream is = res.getInputStream();){
                            if (is != null) {
                                ProtobufSchema protobufSchema = Protobuf.MAPPER.schemaLoader().load(is);
                                return protobufSchema;
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to load Protobuf schema for type: " + t + ", resource: " + res.getLocation(), e);
                    }
                }
                try {
                    return Protobuf.MAPPER.generateSchemaFor(Class.forName(contentClass));
                }
                catch (JsonMappingException | ClassNotFoundException e) {
                    throw new RuntimeException("Unable to compute Protobuf schema for type: " + t, e);
                }
            });
        }
        if (answer != null) {
            this.schema = answer;
        }
        return answer;
    }
}

