/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kamelets.utils.format.converter.avro;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.dataformat.avro.AvroSchema;
import java.io.InputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.avro.Schema;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.jackson.SchemaResolver;
import org.apache.camel.kamelets.utils.format.SchemaType;
import org.apache.camel.kamelets.utils.format.converter.avro.Avro;
import org.apache.camel.kamelets.utils.format.converter.utils.SchemaHelper;
import org.apache.camel.spi.Resource;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.ObjectHelper;

public class AvroSchemaResolver
implements SchemaResolver,
Processor {
    private final ConcurrentMap<String, AvroSchema> schemes = new ConcurrentHashMap<String, AvroSchema>();
    private AvroSchema schema;
    private String contentClass;
    private boolean validate = true;

    public String getSchema() {
        if (this.schema != null) {
            return this.schema.getAvroSchema().toString();
        }
        return null;
    }

    public void setSchema(String schema) {
        this.schema = ObjectHelper.isNotEmpty((String)schema) ? new AvroSchema(new Schema.Parser().setValidate(this.validate).parse(schema)) : null;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public String getContentClass() {
        return this.contentClass;
    }

    public void setContentClass(String contentClass) {
        this.contentClass = ObjectHelper.isNotEmpty((String)contentClass) ? contentClass : null;
    }

    public void process(Exchange exchange) throws Exception {
        Object payload = exchange.getMessage().getBody();
        if (payload == null) {
            return;
        }
        AvroSchema answer = this.computeIfAbsent(exchange);
        if (answer != null) {
            exchange.setProperty("X-Content-Schema", (Object)answer);
            exchange.setProperty("X-Content-Schema-Type", (Object)SchemaType.AVRO.type());
            exchange.setProperty("X-Content-Class", (Object)SchemaHelper.resolveContentClass(exchange, this.contentClass));
        }
    }

    public FormatSchema resolve(Exchange exchange) {
        AvroSchema answer = (AvroSchema)exchange.getProperty("X-Content-Schema", AvroSchema.class);
        if (answer == null) {
            answer = this.computeIfAbsent(exchange);
        }
        return answer;
    }

    private AvroSchema computeIfAbsent(Exchange exchange) {
        String contentClass;
        if (this.schema != null) {
            return this.schema;
        }
        AvroSchema answer = (AvroSchema)exchange.getProperty("X-Content-Schema", AvroSchema.class);
        if (answer == null && exchange.getProperties().containsKey("schema")) {
            String schemaJson = (String)exchange.getProperty("schema", String.class);
            Schema raw = new Schema.Parser().setValidate(this.validate).parse(schemaJson);
            answer = new AvroSchema(raw);
        }
        if (answer == null && (contentClass = SchemaHelper.resolveContentClass(exchange, this.contentClass)) != null) {
            answer = this.schemes.computeIfAbsent(contentClass, t -> {
                block11: {
                    Resource res = PluginHelper.getResourceLoader((CamelContext)exchange.getContext()).resolveResource("classpath:schemas/" + SchemaType.AVRO.type() + "/" + t + "." + SchemaType.AVRO.type());
                    try {
                        if (!res.exists()) break block11;
                        try (InputStream is = res.getInputStream();){
                            if (is != null) {
                                AvroSchema avroSchema = Avro.MAPPER.schemaFrom(is);
                                return avroSchema;
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to load Avro schema for type: " + t + ", resource: " + res.getLocation(), e);
                    }
                }
                try {
                    return Avro.MAPPER.schemaFor(Class.forName(contentClass));
                }
                catch (JsonMappingException | ClassNotFoundException e) {
                    throw new RuntimeException("Unable to compute Avro schema for type: " + t, e);
                }
            });
        }
        if (answer != null) {
            this.schema = answer;
        }
        return answer;
    }
}

