/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.cloud;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.CamelContext;
import org.apache.camel.cloud.ServiceFilter;
import org.apache.camel.model.cloud.BlacklistServiceCallServiceFilterConfiguration;
import org.apache.camel.model.cloud.CustomServiceCallServiceFilterConfiguration;
import org.apache.camel.model.cloud.HealthyServiceCallServiceFilterConfiguration;
import org.apache.camel.model.cloud.PassThroughServiceCallServiceFilterConfiguration;
import org.apache.camel.model.cloud.ServiceCallDefinition;
import org.apache.camel.model.cloud.ServiceCallServiceFilterConfiguration;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;

@Metadata(label="routing,cloud,service-filter")
@XmlRootElement(name="combinedServiceFilter")
@XmlAccessorType(value=XmlAccessType.FIELD)
@Configurer(extended=true)
@Deprecated
public class CombinedServiceCallServiceFilterConfiguration
extends ServiceCallServiceFilterConfiguration {
    @XmlElements(value={@XmlElement(name="blacklistServiceFilter", type=BlacklistServiceCallServiceFilterConfiguration.class), @XmlElement(name="customServiceFilter", type=CustomServiceCallServiceFilterConfiguration.class), @XmlElement(name="healthyServiceFilter", type=HealthyServiceCallServiceFilterConfiguration.class), @XmlElement(name="passThroughServiceFilter", type=PassThroughServiceCallServiceFilterConfiguration.class)})
    private List<ServiceCallServiceFilterConfiguration> serviceFilterConfigurations;

    public CombinedServiceCallServiceFilterConfiguration() {
        this(null);
    }

    public CombinedServiceCallServiceFilterConfiguration(ServiceCallDefinition parent) {
        super(parent, "combined-service-filter");
    }

    public List<ServiceCallServiceFilterConfiguration> getServiceFilterConfigurations() {
        return this.serviceFilterConfigurations;
    }

    public void setServiceFilterConfigurations(List<ServiceCallServiceFilterConfiguration> serviceFilterConfigurations) {
        this.serviceFilterConfigurations = serviceFilterConfigurations;
    }

    public void addServiceFilterConfiguration(ServiceCallServiceFilterConfiguration serviceFilterConfiguration) {
        if (this.serviceFilterConfigurations == null) {
            this.serviceFilterConfigurations = new ArrayList<ServiceCallServiceFilterConfiguration>();
        }
        this.serviceFilterConfigurations.add(serviceFilterConfiguration);
    }

    public CombinedServiceCallServiceFilterConfiguration serviceFilterConfigurations(List<ServiceCallServiceFilterConfiguration> serviceFilterConfigurations) {
        this.setServiceFilterConfigurations(serviceFilterConfigurations);
        return this;
    }

    public CombinedServiceCallServiceFilterConfiguration serviceFilterConfiguration(ServiceCallServiceFilterConfiguration serviceFilterConfiguration) {
        this.addServiceFilterConfiguration(serviceFilterConfiguration);
        return this;
    }

    public CombinedServiceCallServiceFilterConfiguration healthy() {
        this.addServiceFilterConfiguration(new HealthyServiceCallServiceFilterConfiguration());
        return this;
    }

    public CombinedServiceCallServiceFilterConfiguration passThrough() {
        this.addServiceFilterConfiguration(new PassThroughServiceCallServiceFilterConfiguration());
        return this;
    }

    public CombinedServiceCallServiceFilterConfiguration custom(String serviceFilter) {
        this.addServiceFilterConfiguration(new CustomServiceCallServiceFilterConfiguration().serviceFilter(serviceFilter));
        return this;
    }

    public CombinedServiceCallServiceFilterConfiguration custom(ServiceFilter serviceFilter) {
        this.addServiceFilterConfiguration(new CustomServiceCallServiceFilterConfiguration().serviceFilter(serviceFilter));
        return this;
    }

    @Override
    protected void postProcessFactoryParameters(CamelContext camelContext, Map<String, Object> parameters) throws Exception {
        if (this.serviceFilterConfigurations != null && !this.serviceFilterConfigurations.isEmpty()) {
            ArrayList<ServiceFilter> discoveries = new ArrayList<ServiceFilter>(this.serviceFilterConfigurations.size());
            for (ServiceCallServiceFilterConfiguration conf : this.serviceFilterConfigurations) {
                discoveries.add(conf.newInstance(camelContext));
            }
            parameters.put("serviceFilterList", discoveries);
        }
    }
}

