/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kamelets.utils.transform;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Processor;

public class ExtractField
implements Processor {
    String field;
    String headerOutputName;
    boolean headerOutput;
    boolean strictHeaderCheck;
    static final String EXTRACTED_FIELD_HEADER = "CamelKameletsExtractFieldName";

    public ExtractField() {
    }

    public ExtractField(String field) {
        this.field = field;
    }

    public void process(Exchange ex) throws InvalidPayloadException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNodeBody = (JsonNode)ex.getMessage().getBody(JsonNode.class);
        if (jsonNodeBody == null) {
            throw new InvalidPayloadException(ex, JsonNode.class);
        }
        Map body = (Map)mapper.convertValue((Object)jsonNodeBody, (TypeReference)new TypeReference<Map<Object, Object>>(){});
        if (!this.headerOutput || this.strictHeaderCheck && this.checkHeaderExistence(ex)) {
            ex.getMessage().setBody(body.get(this.field));
        } else {
            this.extractToHeader(ex, body);
        }
    }

    private void extractToHeader(Exchange ex, Map<Object, Object> body) {
        if (this.headerOutputName == null || this.headerOutputName.isEmpty() || "none".equalsIgnoreCase(this.headerOutputName)) {
            ex.getMessage().setHeader(EXTRACTED_FIELD_HEADER, body.get(this.field));
        } else {
            ex.getMessage().setHeader(this.headerOutputName, body.get(this.field));
        }
    }

    private boolean checkHeaderExistence(Exchange exchange) {
        if (this.headerOutputName == null || this.headerOutputName.isEmpty() || "none".equalsIgnoreCase(this.headerOutputName)) {
            return exchange.getMessage().getHeaders().containsKey(EXTRACTED_FIELD_HEADER);
        }
        return exchange.getMessage().getHeaders().containsKey(this.headerOutputName);
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setHeaderOutput(boolean headerOutput) {
        this.headerOutput = headerOutput;
    }

    public void setHeaderOutputName(String headerOutputName) {
        this.headerOutputName = headerOutputName;
    }

    public void setStrictHeaderCheck(boolean strictHeaderCheck) {
        this.strictHeaderCheck = strictHeaderCheck;
    }
}

