/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kamelets.utils.format;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.kamelets.utils.format.AnnotationDataTypeLoader;
import org.apache.camel.kamelets.utils.format.DefaultDataTypeConverterResolver;
import org.apache.camel.kamelets.utils.format.converter.standard.BinaryDataType;
import org.apache.camel.kamelets.utils.format.converter.standard.JsonModelDataType;
import org.apache.camel.kamelets.utils.format.converter.standard.StringDataType;
import org.apache.camel.kamelets.utils.format.spi.DataTypeConverter;
import org.apache.camel.kamelets.utils.format.spi.DataTypeConverterResolver;
import org.apache.camel.kamelets.utils.format.spi.DataTypeLoader;
import org.apache.camel.kamelets.utils.format.spi.DataTypeRegistry;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataTypeRegistry
extends ServiceSupport
implements DataTypeRegistry,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDataTypeRegistry.class);
    private CamelContext camelContext;
    protected final List<DataTypeLoader> dataTypeLoaders = new ArrayList<DataTypeLoader>();
    private DataTypeConverterResolver dataTypeConverterResolver;
    private boolean classpathScan = true;
    private boolean useDefaultConverters = true;
    private final Map<String, List<DataTypeConverter>> dataTypeConverters = new HashMap<String, List<DataTypeConverter>>();

    @Override
    public void addDataTypeConverter(String scheme, DataTypeConverter converter) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding data type for scheme {} and name {}", (Object)scheme, (Object)converter.getName());
        }
        this.getComponentDataTypeConverters(scheme).add(converter);
    }

    @Override
    public Optional<DataTypeConverter> lookup(String scheme, String name) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Searching for data type with scheme {} and name {}", (Object)scheme, (Object)name);
        }
        if (this.dataTypeLoaders.isEmpty()) {
            LOG.trace("Lazy initializing data type registry");
            try {
                this.doInit();
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Failed to initialize data type registry", (Throwable)e);
            }
        }
        if (name == null) {
            return Optional.empty();
        }
        Optional<DataTypeConverter> dataTypeConverter = this.getDataTypeConverter(scheme, name);
        if (!dataTypeConverter.isPresent()) {
            dataTypeConverter = this.getDataTypeConverter("camel", name);
        }
        return dataTypeConverter;
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (this.classpathScan) {
            this.dataTypeLoaders.add(new AnnotationDataTypeLoader());
        } else if (this.useDefaultConverters) {
            this.addDataTypeConverter(new BinaryDataType());
            this.addDataTypeConverter(new StringDataType());
            this.addDataTypeConverter(new JsonModelDataType());
        }
        for (DataTypeLoader loader : this.dataTypeLoaders) {
            CamelContextAware.trySetCamelContext((Object)loader, (CamelContext)this.getCamelContext());
            loader.load(this);
        }
        this.dataTypeConverters.values().forEach(converters -> converters.forEach(converter -> {
            if (converter instanceof CamelContextAware && ((CamelContextAware)converter).getCamelContext() == null) {
                CamelContextAware.trySetCamelContext((Object)converter, (CamelContext)this.camelContext);
            }
        }));
        LOG.debug("Loaded {} schemes holding {} data type converters", (Object)this.dataTypeConverters.size(), (Object)this.dataTypeConverters.values().stream().mapToInt(List::size).sum());
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.dataTypeConverters.clear();
    }

    private Optional<DataTypeConverter> getDataTypeConverter(String scheme, String name) {
        Optional<DataTypeConverter> dataTypeConverter;
        if (this.dataTypeConverterResolver == null) {
            this.dataTypeConverterResolver = Optional.ofNullable((DataTypeConverterResolver)this.camelContext.getRegistry().findSingleByType(DataTypeConverterResolver.class)).orElseGet(DefaultDataTypeConverterResolver::new);
        }
        if ((dataTypeConverter = Optional.ofNullable((DataTypeConverter)CamelContextHelper.lookup((CamelContext)this.getCamelContext(), (String)String.format("%s-%s", scheme, name), DataTypeConverter.class))).isPresent()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found data type {} for scheme {} and name {} in Camel registry", new Object[]{ObjectHelper.name(dataTypeConverter.get().getClass()), scheme, name});
            }
            return dataTypeConverter;
        }
        dataTypeConverter = this.getComponentDataTypeConverters(scheme).stream().filter(dtc -> name.equals(dtc.getName())).findFirst();
        if (dataTypeConverter.isPresent()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found data type {} for scheme {} and name {}", new Object[]{ObjectHelper.name(dataTypeConverter.get().getClass()), scheme, name});
            }
            return dataTypeConverter;
        }
        dataTypeConverter = this.dataTypeConverterResolver.resolve(scheme, name, this.camelContext);
        dataTypeConverter.ifPresent(converter -> this.getComponentDataTypeConverters(scheme).add((DataTypeConverter)converter));
        if (LOG.isDebugEnabled() && dataTypeConverter.isPresent()) {
            LOG.debug("Resolved data type {} for scheme {} and name {} via resource path", new Object[]{ObjectHelper.name(dataTypeConverter.get().getClass()), scheme, name});
        }
        return dataTypeConverter;
    }

    private List<DataTypeConverter> getComponentDataTypeConverters(String scheme) {
        return this.dataTypeConverters.computeIfAbsent(scheme, s -> new ArrayList());
    }

    public void setClasspathScan(boolean classpathScan) {
        this.classpathScan = classpathScan;
    }

    public void setUseDefaultConverters(boolean useDefaultConverters) {
        this.useDefaultConverters = useDefaultConverters;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }
}

