/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.resequencer;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.processor.resequencer.Timeout;
import org.apache.camel.processor.resequencer.TimeoutHandler;

class Element<E>
implements TimeoutHandler {
    private final Lock lock = new ReentrantLock();
    private final E object;
    private Timeout timeout;

    Element(E object) {
        this.object = object;
    }

    public E getObject() {
        return this.object;
    }

    public boolean scheduled() {
        this.lock.lock();
        try {
            boolean bl = this.timeout != null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void schedule(Timeout t) {
        this.lock.lock();
        try {
            this.timeout = t;
            this.timeout.setTimeoutHandler(this);
            this.timeout.schedule();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void cancel() {
        this.lock.lock();
        try {
            if (this.timeout != null) {
                this.timeout.cancel();
            }
            this.timeout(null);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void timeout(Timeout t) {
        this.lock.lock();
        try {
            this.timeout = null;
        }
        finally {
            this.lock.unlock();
        }
    }
}

