/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.ExpressionFactory;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.model.OtherwiseDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.AsPredicate;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@XmlRootElement(name="choice")
@XmlType(propOrder={"whenClauses", "otherwise"})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ChoiceDefinition
extends NoOutputDefinition<ChoiceDefinition> {
    @XmlElementRef(name="when")
    @AsPredicate
    @Metadata(description="Sets the when nodes")
    private List<WhenDefinition> whenClauses = new ArrayList<WhenDefinition>();
    @XmlElement
    @Metadata(description="Sets the otherwise node")
    private OtherwiseDefinition otherwise;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean", defaultValue="false")
    private String precondition;

    public ChoiceDefinition() {
    }

    protected ChoiceDefinition(ChoiceDefinition source) {
        super(source);
        this.whenClauses = ProcessorDefinitionHelper.deepCopyDefinitions(source.whenClauses);
        this.otherwise = source.otherwise != null ? source.otherwise.copyDefinition() : null;
        this.precondition = source.precondition;
    }

    @Override
    public ChoiceDefinition copyDefinition() {
        return new ChoiceDefinition(this);
    }

    public String toString() {
        return "Choice[" + String.valueOf(this.getWhenClauses()) + (String)(this.getOtherwise() != null ? " " + String.valueOf(this.getOtherwise()) : "") + "]";
    }

    public String getPrecondition() {
        return this.precondition;
    }

    public void setPrecondition(String precondition) {
        this.precondition = precondition;
    }

    @Override
    public void addOutput(ProcessorDefinition<?> output) {
        if (this.otherwise != null) {
            output.setParent(this);
            this.otherwise.addOutput(output);
        } else if (!this.whenClauses.isEmpty()) {
            output.setParent(this);
            WhenDefinition last = this.whenClauses.get(this.whenClauses.size() - 1);
            last.addOutput(output);
        } else {
            super.addOutput(output);
        }
    }

    public void addOutput(WhenDefinition when) {
        when.setParent(this);
        this.whenClauses.add(when);
    }

    public void addOutput(OtherwiseDefinition other) {
        other.setParent(this);
        this.otherwise = other;
    }

    @Override
    public ChoiceDefinition disabled(String disabled) {
        if (this.otherwise != null && this.otherwise.getOutputs().isEmpty()) {
            this.otherwise.setDisabled(disabled);
        } else if (!this.whenClauses.isEmpty()) {
            WhenDefinition last = this.whenClauses.get(this.whenClauses.size() - 1);
            if (last.getOutputs().isEmpty()) {
                last.setDisabled(disabled);
            } else {
                super.disabled(disabled);
            }
        } else {
            super.disabled(disabled);
        }
        return this;
    }

    public ChoiceDefinition precondition() {
        return this.precondition(true);
    }

    public ChoiceDefinition precondition(boolean precondition) {
        this.setPrecondition(Boolean.toString(precondition));
        return this;
    }

    public ChoiceDefinition when(@AsPredicate Predicate predicate) {
        this.addClause(new WhenDefinition(predicate));
        return this;
    }

    @AsPredicate
    public ExpressionClause<ChoiceDefinition> when() {
        ExpressionClause<ChoiceDefinition> clause = new ExpressionClause<ChoiceDefinition>(this);
        this.addClause(new WhenDefinition(clause));
        return clause;
    }

    public ChoiceDefinition otherwise() {
        OtherwiseDefinition answer = new OtherwiseDefinition();
        this.addClause(answer);
        return this;
    }

    private void addClause(WhenDefinition when) {
        this.popBlock();
        this.addOutput(when);
        this.pushBlock(when);
    }

    private void addClause(OtherwiseDefinition other) {
        this.popBlock();
        this.addOutput(other);
        this.pushBlock(other);
    }

    @Override
    public void setId(String id) {
        if (this.otherwise != null) {
            this.otherwise.setId(id);
        } else if (!this.getWhenClauses().isEmpty()) {
            WhenDefinition last = this.getWhenClauses().get(this.getWhenClauses().size() - 1);
            last.setId(id);
        } else {
            super.setId(id);
        }
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        ArrayList answer = new ArrayList();
        for (WhenDefinition when : this.whenClauses) {
            answer.addAll(when.getOutputs());
        }
        if (this.otherwise != null) {
            answer.addAll(this.otherwise.getOutputs());
        }
        return answer;
    }

    public String getShortName() {
        return "choice";
    }

    @Override
    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append("choice[");
        for (WhenDefinition when : this.whenClauses) {
            sb.append(when.getLabel());
        }
        if (this.otherwise != null) {
            sb.append(this.otherwise.getLabel());
        }
        sb.append("]");
        return sb.toString();
    }

    public List<WhenDefinition> getWhenClauses() {
        return this.whenClauses;
    }

    public void setWhenClauses(List<WhenDefinition> whenClauses) {
        this.whenClauses = whenClauses;
    }

    public OtherwiseDefinition getOtherwise() {
        return this.otherwise;
    }

    public void setOtherwise(OtherwiseDefinition otherwise) {
        this.otherwise = otherwise;
    }

    @Override
    public void preCreateProcessor() {
        if (this.whenClauses == null || this.whenClauses.isEmpty()) {
            return;
        }
        for (WhenDefinition when : this.whenClauses) {
            ExpressionFactory model;
            ExpressionClause clause;
            Predicate pre;
            ExpressionDefinition exp = when.getExpression();
            if (exp.getExpressionType() != null) {
                exp = exp.getExpressionType();
            }
            if (!((pre = exp.getPredicate()) instanceof ExpressionClause) || (clause = (ExpressionClause)pre).getExpressionType() == null || !((model = clause.getExpressionType()) instanceof ExpressionDefinition)) continue;
            ExpressionDefinition expressionDefinition = (ExpressionDefinition)model;
            when.setExpression(expressionDefinition);
        }
    }
}

