/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.devconsole;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.camel.component.kafka.consumer.devconsole.DevConsoleMetricsCollector;
import org.apache.camel.component.kafka.consumer.support.ProcessingResult;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMetricsCollector
implements DevConsoleMetricsCollector {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMetricsCollector.class);
    private final String threadId;
    private volatile DevConsoleMetricsCollector.GroupMetadata groupMetadata;
    private volatile DevConsoleMetricsCollector.KafkaTopicPosition lastRecord;
    private final List<DevConsoleMetricsCollector.KafkaTopicPosition> commitRecords = new ArrayList<DevConsoleMetricsCollector.KafkaTopicPosition>();
    private final AtomicBoolean commitRecordsRequested = new AtomicBoolean();
    private final AtomicReference<CountDownLatch> latch = new AtomicReference();

    public DefaultMetricsCollector(String threadId) {
        this.threadId = threadId;
    }

    @Override
    public void storeMetadata(Consumer<?, ?> consumer) {
        ConsumerGroupMetadata meta = consumer.groupMetadata();
        if (meta != null) {
            this.groupMetadata = new DevConsoleMetricsCollector.GroupMetadata(meta.groupId(), meta.groupInstanceId().orElse(""), meta.memberId(), meta.generationId());
        }
    }

    @Override
    public void storeLastRecord(ProcessingResult result) {
        this.lastRecord = new DevConsoleMetricsCollector.KafkaTopicPosition(result.getTopic(), result.getPartition(), result.getOffset(), 0);
    }

    @Override
    public void collectCommitMetrics(Consumer<?, ?> consumer) {
        if (this.commitRecordsRequested.compareAndSet(true, false)) {
            try {
                Map commits = consumer.committed(consumer.assignment());
                this.commitRecords.clear();
                for (Map.Entry e : commits.entrySet()) {
                    DevConsoleMetricsCollector.KafkaTopicPosition p = new DevConsoleMetricsCollector.KafkaTopicPosition(((TopicPartition)e.getKey()).topic(), ((TopicPartition)e.getKey()).partition(), ((OffsetAndMetadata)e.getValue()).offset(), ((OffsetAndMetadata)e.getValue()).leaderEpoch().orElse(0));
                    this.commitRecords.add(p);
                }
                CountDownLatch count = this.latch.get();
                if (count != null) {
                    count.countDown();
                }
            }
            catch (Exception e) {
                LOG.debug("Cannot get last offset committed from Kafka brokers due to: {}. This exception is ignored.", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    @Override
    public DevConsoleMetricsCollector.GroupMetadata getGroupMetadata() {
        return this.groupMetadata;
    }

    @Override
    public DevConsoleMetricsCollector.KafkaTopicPosition getLastRecord() {
        return this.lastRecord;
    }

    @Override
    public String getThreadId() {
        return this.threadId;
    }

    @Override
    public List<DevConsoleMetricsCollector.KafkaTopicPosition> getCommitRecords() {
        return Collections.unmodifiableList(this.commitRecords);
    }

    @Override
    public CountDownLatch fetchCommitRecords() {
        CountDownLatch answer = new CountDownLatch(1);
        this.latch.set(answer);
        this.commitRecordsRequested.set(true);
        return answer;
    }
}

