/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kamelet.utils.transform;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Processor;
import org.apache.camel.support.LanguageSupport;

public class InsertField
implements Processor {
    String field;
    String value;

    public InsertField() {
    }

    public InsertField(String field, String value) {
        this.field = field;
        this.value = value;
    }

    public void process(Exchange ex) throws InvalidPayloadException {
        JsonNode body = (JsonNode)ex.getMessage().getBody(JsonNode.class);
        if (body == null) {
            throw new InvalidPayloadException(ex, JsonNode.class);
        }
        String resolvedValue = LanguageSupport.hasSimpleFunction((String)this.value) ? (String)ex.getContext().resolveLanguage("simple").createExpression(this.value).evaluate(ex, String.class) : this.value;
        switch (body.getNodeType()) {
            case ARRAY: {
                ((ArrayNode)body).add(resolvedValue);
                break;
            }
            case OBJECT: {
                ((ObjectNode)body).put(this.field, resolvedValue);
                break;
            }
            default: {
                ((ObjectNode)body).put(this.field, resolvedValue);
            }
        }
        ex.getMessage().setBody((Object)body);
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

