/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.AggregationStrategyAwareDefinition;
import org.apache.camel.model.PollEnrichDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.language.ConstantExpression;
import org.apache.camel.processor.PollEnricher;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.support.DefaultExchange;

public class PollEnrichReifier
extends ProcessorReifier<PollEnrichDefinition> {
    public PollEnrichReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (PollEnrichDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        Integer num;
        PollEnricher enricher;
        long time = this.parseDuration(((PollEnrichDefinition)this.definition).getTimeout(), -1L);
        boolean isIgnoreInvalidEndpoint = this.parseBoolean(((PollEnrichDefinition)this.definition).getIgnoreInvalidEndpoint(), false);
        boolean isAggregateOnException = this.parseBoolean(((PollEnrichDefinition)this.definition).getAggregateOnException(), false);
        if (((PollEnrichDefinition)this.definition).getExpression() instanceof ConstantExpression) {
            exp = this.createExpression(((PollEnrichDefinition)this.definition).getExpression());
            DefaultExchange ex = new DefaultExchange(this.camelContext);
            String dest = (String)exp.evaluate((Exchange)ex, String.class);
            enricher = new PollEnricher(dest, time);
        } else {
            exp = this.createExpression(((PollEnrichDefinition)this.definition).getExpression());
            enricher = new PollEnricher(exp, time);
        }
        AggregationStrategy strategy = this.getConfiguredAggregationStrategy((AggregationStrategyAwareDefinition)this.definition);
        if (strategy != null) {
            enricher.setAggregationStrategy(strategy);
        }
        if ((num = this.parseInt(((PollEnrichDefinition)this.definition).getCacheSize())) != null) {
            enricher.setCacheSize(num.intValue());
        }
        enricher.setIgnoreInvalidEndpoint(isIgnoreInvalidEndpoint);
        enricher.setAggregateOnException(isAggregateOnException);
        return enricher;
    }
}

