/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml.deserializers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializerSupport;
import org.apache.camel.model.app.RegistryBeanDefinition;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.annotations.YamlIn;
import org.apache.camel.spi.annotations.YamlProperty;
import org.apache.camel.spi.annotations.YamlType;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.ObjectHelper;
import org.snakeyaml.engine.v2.api.ConstructNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.SequenceNode;

@YamlIn
@YamlType(nodes={"beans"}, order=0, properties={@YamlProperty(name="__extends", type="array:org.apache.camel.model.app.RegistryBeanDefinition")})
public class BeansDeserializer
extends YamlDeserializerSupport
implements ConstructNode {
    public Object construct(Node node) {
        BeansCustomizer answer = new BeansCustomizer();
        SequenceNode sn = BeansDeserializer.asSequenceNode((Node)node);
        YamlDeserializationContext dc = BeansDeserializer.getDeserializationContext((Node)node);
        for (Node item : sn.getValue()) {
            BeansDeserializer.setDeserializationContext((Node)item, (YamlDeserializationContext)dc);
            RegistryBeanDefinition bean = (RegistryBeanDefinition)BeansDeserializer.asType((Node)item, RegistryBeanDefinition.class);
            ObjectHelper.notNull((Object)bean.getName(), (String)"The bean name must be set");
            ObjectHelper.notNull((Object)bean.getType(), (String)"The bean type must be set");
            if (!bean.getType().startsWith("#class:")) {
                bean.setType("#class:" + bean.getType());
            }
            answer.addBean(bean);
        }
        return answer;
    }

    public Object newInstance(RegistryBeanDefinition bean, CamelContext context) throws Exception {
        Object target = PropertyBindingSupport.resolveBean((CamelContext)context, (Object)bean.getType());
        if (bean.getProperties() != null && !bean.getProperties().isEmpty()) {
            PropertyBindingSupport.setPropertiesOnTarget((CamelContext)context, (Object)target, (Map)bean.getProperties());
        }
        return target;
    }

    protected void registerBean(CamelContext camelContext, List<RegistryBeanDefinition> delayedRegistrations, RegistryBeanDefinition def, boolean delayIfFailed) {
        try {
            String name = def.getName();
            Object bean = this.newInstance(def, camelContext);
            camelContext.getRegistry().unbind(name);
            camelContext.getRegistry().bind(name, bean);
        }
        catch (Exception e) {
            if (delayIfFailed) {
                delayedRegistrations.add(def);
            }
            throw new RuntimeException(e);
        }
    }

    private class BeansCustomizer
    implements CamelContextCustomizer {
        private final List<RegistryBeanDefinition> delayedRegistrations = new ArrayList<RegistryBeanDefinition>();
        private final List<RegistryBeanDefinition> beans = new ArrayList<RegistryBeanDefinition>();

        private BeansCustomizer() {
        }

        public void addBean(RegistryBeanDefinition bean) {
            this.beans.add(bean);
        }

        public void configure(CamelContext camelContext) {
            for (RegistryBeanDefinition bean : this.beans) {
                BeansDeserializer.this.registerBean(camelContext, this.delayedRegistrations, bean, true);
            }
            this.beans.clear();
            for (RegistryBeanDefinition bean : this.delayedRegistrations) {
                BeansDeserializer.this.registerBean(camelContext, this.delayedRegistrations, bean, false);
            }
            this.delayedRegistrations.clear();
        }
    }
}

