/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.util.List;
import java.util.Map;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.KafkaConsumer;
import org.apache.camel.component.kafka.TaskHealthState;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;

public class KafkaConsumerHealthCheck
extends AbstractHealthCheck {
    private final KafkaConsumer kafkaConsumer;
    private final String routeId;

    public KafkaConsumerHealthCheck(KafkaConsumer kafkaConsumer, String routeId) {
        super("camel", "kafka-consumer-" + routeId);
        this.kafkaConsumer = kafkaConsumer;
        this.routeId = routeId;
    }

    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        List<TaskHealthState> healthStates = this.kafkaConsumer.healthStates();
        for (TaskHealthState healthState : healthStates) {
            String gid;
            if (healthState.isReady()) continue;
            builder.down();
            String msg = healthState.buildStateMessage();
            builder.message(msg);
            builder.error((Throwable)healthState.getLastError());
            KafkaConfiguration cfg = this.kafkaConsumer.getEndpoint().getConfiguration();
            if (healthState.getBootstrapServers() != null) {
                builder.detail("bootstrap.servers", (Object)healthState.getBootstrapServers());
            }
            if (healthState.getClientId() != null) {
                builder.detail("client.id", (Object)healthState.getClientId());
            }
            if ((gid = healthState.getGroupId()) != null) {
                builder.detail("group.id", (Object)gid);
            }
            if (this.routeId != null) {
                builder.detail("route.id", (Object)this.routeId);
            }
            builder.detail("topic", (Object)cfg.getTopic());
            return;
        }
        builder.up();
    }
}

