/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.Endpoint;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.DefaultErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.model.errorhandler.DeadLetterChannelConfiguration;
import org.apache.camel.model.errorhandler.DeadLetterChannelProperties;
import org.apache.camel.model.errorhandler.DefaultErrorHandlerConfiguration;
import org.apache.camel.processor.errorhandler.DeadLetterChannel;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.Configurer;
import org.slf4j.LoggerFactory;

@Configurer
public class DeadLetterChannelBuilder
extends DefaultErrorHandlerBuilder
implements DeadLetterChannelProperties {
    public DeadLetterChannelBuilder() {
    }

    public DeadLetterChannelBuilder(Endpoint deadLetter) {
        this.setDeadLetterUri(deadLetter.getEndpointUri());
        this.getRedeliveryPolicy().setLogExhausted(false);
    }

    public DeadLetterChannelBuilder(String uri) {
        this.setDeadLetterUri(uri);
    }

    @Override
    DefaultErrorHandlerConfiguration createConfiguration() {
        return new DeadLetterChannelConfiguration();
    }

    @Override
    public ErrorHandlerBuilder cloneBuilder() {
        DeadLetterChannelBuilder answer = new DeadLetterChannelBuilder();
        super.cloneBuilder(answer);
        return answer;
    }

    @Override
    protected CamelLogger createLogger() {
        return new CamelLogger(LoggerFactory.getLogger(DeadLetterChannel.class), LoggingLevel.ERROR);
    }

    @Override
    public String toString() {
        return "DeadLetterChannelBuilder(" + this.getDeadLetterUri() + ")";
    }
}

