/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kamelets.utils.transform.aws2.ddb;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.time.Instant;
import org.apache.camel.Message;
import org.apache.camel.kamelets.utils.serialization.gson.JavaTimeInstantTypeAdapter;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="aws2-ddb:application-x-struct")
public class Ddb2JsonStructDataTypeTransformer
extends Transformer {
    private final Gson gson = new GsonBuilder().registerTypeAdapter(Instant.class, (Object)new JavaTimeInstantTypeAdapter()).create();

    public void transform(Message message, DataType fromType, DataType toType) {
        if (message.getBody() instanceof String) {
            return;
        }
        message.setBody((Object)this.gson.toJson(message.getBody()));
    }
}

