/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Service;
import org.apache.camel.StreamCache;
import org.apache.camel.support.AbstractVariableRepository;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.CaseInsensitiveMap;
import org.apache.camel.util.StringHelper;

final class HeaderVariableRepository
extends AbstractVariableRepository {
    public HeaderVariableRepository(CamelContext camelContext) {
        this.setCamelContext(camelContext);
        ServiceHelper.startService((Service)this);
    }

    public String getId() {
        return "header";
    }

    @Override
    public Object getVariable(String name) {
        Object answer = super.getVariable(name);
        if (answer == null && !name.contains(".")) {
            String prefix = name + ".";
            CaseInsensitiveMap map = new CaseInsensitiveMap();
            for (Map.Entry<String, Object> entry : this.getVariables().entrySet()) {
                String key = entry.getKey();
                if (!key.startsWith(prefix)) continue;
                key = StringHelper.after((String)key, (String)prefix);
                map.put(key, entry.getValue());
            }
            return map;
        }
        if (answer instanceof StreamCache) {
            StreamCache sc = (StreamCache)answer;
            sc.reset();
        }
        return answer;
    }
}

