/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kamelets.utils.format.converter.utils;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.camel.Exchange;

public class CloudEvents {
    public static final String CAMEL_CLOUD_EVENT_ID = "CamelCloudEventID";
    public static final String CAMEL_CLOUD_EVENT_VERSION = "CamelCloudEventVersion";
    public static final String CAMEL_CLOUD_EVENT_TYPE = "CamelCloudEventType";
    public static final String CAMEL_CLOUD_EVENT_SOURCE = "CamelCloudEventSource";
    public static final String CAMEL_CLOUD_EVENT_SUBJECT = "CamelCloudEventSubject";
    public static final String CAMEL_CLOUD_EVENT_TIME = "CamelCloudEventTime";
    public static final String CAMEL_CLOUD_EVENT_CONTENT_TYPE = "Content-Type";

    public static String getEventTime(Exchange exchange) {
        ZonedDateTime created = ZonedDateTime.ofInstant(Instant.ofEpochMilli(exchange.getCreated()), ZoneId.systemDefault());
        return DateTimeFormatter.ISO_INSTANT.format(created);
    }
}

