/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kamelets.utils.format.converter.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Message;
import org.apache.camel.kamelets.utils.format.MimeType;
import org.apache.camel.kamelets.utils.format.converter.json.Json;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="application-json")
public class JsonDataType
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) {
        try {
            byte[] marshalled = Json.MAPPER.writer().forType(JsonNode.class).writeValueAsBytes(message.getBody());
            message.setBody((Object)marshalled);
            message.setHeader("Content-Type", (Object)MimeType.JSON.type());
            message.setHeader("X-Content-Schema", message.getExchange().getProperty("X-Content-Schema", (Object)"", String.class));
        }
        catch (JsonProcessingException e) {
            throw new CamelExecutionException("Failed to apply Json output data type on exchange", message.getExchange(), (Throwable)e);
        }
    }
}

